/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.auth.rmi.impl;

import com.openexchange.auth.Authenticator;
import com.openexchange.auth.Credentials;
import com.openexchange.auth.mbean.impl.AuthenticatorMBeanImpl;
import com.openexchange.auth.rmi.RemoteAuthenticator;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import java.rmi.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAuthenticatorImpl
implements RemoteAuthenticator {
    public boolean isMasterAuthenticationDisabled() throws RemoteException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            return authenticator.isMasterAuthenticationDisabled();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new RemoteException(message, new Exception(message));
        }
    }

    public boolean isContextAuthenticationDisabled() throws RemoteException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            return authenticator.isContextAuthenticationDisabled();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new RemoteException(message, new Exception(message));
        }
    }

    public void doAuthentication(String login, String password) throws RemoteException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doAuthentication(new Credentials(login, password));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new RemoteException(message, new Exception(message));
        }
    }

    public void doAuthentication(String login, String password, int contextId) throws RemoteException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doAuthentication(new Credentials(login, password), contextId);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new RemoteException(message, new Exception(message));
        }
    }

    public void doUserAuthentication(String login, String password, int contextId) throws RemoteException {
        Logger logger = LoggerFactory.getLogger(AuthenticatorMBeanImpl.class);
        try {
            Authenticator authenticator = ServerServiceRegistry.getInstance().getService(Authenticator.class);
            if (null == authenticator) {
                throw ServiceExceptionCode.absentService(Authenticator.class);
            }
            authenticator.doUserAuthentication(new Credentials(login, password), contextId);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new RemoteException(message, new Exception(message));
        }
    }
}

