/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.login.ConfigurationProperty;
import com.openexchange.login.LoginResult;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginWriter {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final Logger LOG = LoggerFactory.getLogger(LoginWriter.class);
    private static final String PARAMETER_USER_ID = "user_id";
    private static final String PARAMETER_CONTEXT_ID = "context_id";
    private static final String PARAMETER_USER = "user";
    private static final String RANDOM_PARAM = "random";
    private static final String PARAMETER_SESSION = "session";
    private static final String PARAMETER_LOCALE = "locale";
    private static volatile Boolean randomTokenEnabled;

    public void writeLogin(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result, json);
    }

    public void writeLogin(Session session, JSONObject json) throws JSONException {
        LoginWriter.write(session, json);
    }

    public static void write(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result.getSession(), json, result.warnings(), result.getUser().getLocale());
    }

    public static void write(Session session, JSONObject json) throws JSONException {
        Locale locale = null;
        if (session instanceof ServerSession) {
            locale = ((ServerSession)session).getUser().getLocale();
        } else {
            try {
                locale = UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LoginWriter.write(session, json, Collections.emptyList(), locale);
    }

    public static void write(Session session, JSONObject json, Locale locale) throws JSONException {
        LoginWriter.write(session, json, Collections.emptyList(), locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean randomTokenEnabled() {
        Boolean tmp = randomTokenEnabled;
        if (null != tmp) return tmp;
        Class<LoginWriter> clazz = LoginWriter.class;
        synchronized (LoginWriter.class) {
            tmp = randomTokenEnabled;
            if (null != tmp) return tmp;
            ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            if (configurationService == null) {
                LOG.warn("Unable to get ConfigurationService, refusing to write random.");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            randomTokenEnabled = tmp = Boolean.valueOf(configurationService.getBoolProperty(ConfigurationProperty.RANDOM_TOKEN.getPropertyName(), false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static void invalidateRandomTokenEnabled() {
        randomTokenEnabled = null;
    }

    private static void write(Session session, JSONObject json, Collection<OXException> warnings, Locale locale) throws JSONException {
        if (LoginWriter.randomTokenEnabled()) {
            json.put(RANDOM_PARAM, (Object)session.getRandomToken());
        }
        json.put(PARAMETER_SESSION, (Object)session.getSessionID());
        json.put(PARAMETER_USER, (Object)LoginWriter.prepareLogin(session.getLogin()));
        json.put(PARAMETER_USER_ID, session.getUserId());
        json.put(PARAMETER_CONTEXT_ID, session.getContextId());
        Locale loc = locale == null ? LoginWriter.resolveLocaleForUser(session, DEFAULT_LOCALE) : locale;
        json.put(PARAMETER_LOCALE, (Object)loc.toString());
        if (null != warnings && !warnings.isEmpty()) {
            OXJSONWriter writer = new OXJSONWriter(json);
            List<Object> list = warnings instanceof List ? (List<Object>)warnings : new ArrayList<OXException>(warnings);
            ResponseWriter.writeWarnings((List<OXException>)list, writer, loc);
        }
    }

    private static String prepareLogin(String login) {
        if (null == login) {
            return null;
        }
        try {
            return QuotedInternetAddress.toIDN(login);
        }
        catch (Exception x) {
            return login;
        }
    }

    private static Locale resolveLocaleForUser(Session session, Locale defaultLocale) {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        try {
            return UserStorage.getInstance().getUser(session.getUserId(), session.getContextId()).getLocale();
        }
        catch (Exception e) {
            return defaultLocale;
        }
    }
}

