/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.BodyParser;
import com.openexchange.ajax.requesthandler.DefaultBodyParser;
import com.openexchange.java.ConcurrentList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class BodyParserRegistry
extends ServiceTracker<BodyParser, BodyParser> {
    private final ConcurrentList<BodyParser> parsers = new ConcurrentList(Collections.singletonList(DefaultBodyParser.getInstance()));

    public BodyParserRegistry(BundleContext context) {
        super(context, BodyParser.class, null);
    }

    public BodyParser addingService(ServiceReference<BodyParser> reference) {
        BodyParser bodyParser = (BodyParser)this.context.getService(reference);
        if (this.parsers.addIfAbsent((Object)bodyParser)) {
            return bodyParser;
        }
        return null;
    }

    public void removedService(ServiceReference<BodyParser> reference, BodyParser bodyParser) {
        this.parsers.remove((Object)bodyParser);
        this.context.ungetService(reference);
    }

    public BodyParser getParserFor(AJAXRequestData requestData) {
        BodyParser candidate = null;
        for (BodyParser parser : this.parsers) {
            if (!parser.accepts(requestData) || null != candidate && candidate.getRanking() >= parser.getRanking()) continue;
            candidate = parser;
        }
        return candidate;
    }

    public List<BodyParser> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }
}

