/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.Folder;
import com.openexchange.exception.OXException;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class FolderRequest {
    private final ServerSession session;
    private final JSONWriter pw;
    private static final Folder FOLDER_SERVLET = new Folder();

    public FolderRequest(ServerSession session, JSONWriter pw) {
        this.session = session;
        this.pw = pw;
    }

    public void action(String action, JSONObject jsonObject) throws JSONException, OXException {
        if (action.equalsIgnoreCase("root")) {
            FOLDER_SERVLET.actionGetRoot(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("list")) {
            FOLDER_SERVLET.actionGetSubfolders(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("path")) {
            FOLDER_SERVLET.actionGetPath(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("updates")) {
            FOLDER_SERVLET.actionGetUpdatedFolders(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("get")) {
            FOLDER_SERVLET.actionGetFolder(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("update")) {
            FOLDER_SERVLET.actionPutUpdateFolder(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("new")) {
            FOLDER_SERVLET.actionPutInsertFolder(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("delete")) {
            FOLDER_SERVLET.actionPutDeleteFolder(this.session, this.pw, jsonObject);
        } else if (action.equalsIgnoreCase("clear")) {
            FOLDER_SERVLET.actionPutClearFolder(this.session, this.pw, jsonObject);
        } else {
            throw OXFolderExceptionCode.UNKNOWN_ACTION.create(action);
        }
    }
}

