/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.customizer.folder;

import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BulkFolderField
implements AdditionalFolderField {
    private static final Object NULL = new Object();
    private final AdditionalFolderField delegate;
    private final Map<String, Object> values = new HashMap<String, Object>();

    public BulkFolderField(AdditionalFolderField delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getColumnID() {
        return this.delegate.getColumnID();
    }

    @Override
    public String getColumnName() {
        return this.delegate.getColumnName();
    }

    @Override
    public Object getValue(FolderObject f, ServerSession session) {
        Object value;
        String fn = f.getFullName();
        if (fn == null) {
            fn = Integer.toString(f.getObjectID());
        }
        if (!this.values.containsKey(fn)) {
            this.getValues(Collections.singletonList(f), session);
        }
        return NULL == (value = this.values.get(fn)) ? null : value;
    }

    @Override
    public List<Object> getValues(List<FolderObject> folders2, ServerSession session) {
        ArrayList<FolderObject> fl = new ArrayList<FolderObject>(folders2.size());
        for (FolderObject f : folders2) {
            String fn = f.getFullName();
            if (this.values.containsKey(fn == null ? Integer.toString(f.getObjectID()) : fn)) continue;
            fl.add(f);
        }
        if (!fl.isEmpty()) {
            this.warmUp(fl, session);
        }
        ArrayList<Object> vals = new ArrayList<Object>(folders2.size());
        for (FolderObject f : folders2) {
            String fn = f.getFullName();
            Object value = this.values.get(fn == null ? Integer.toString(f.getObjectID()) : fn);
            vals.add(NULL == value ? null : value);
        }
        return vals;
    }

    @Override
    public Object renderJSON(AJAXRequestData requestData, Object value) {
        return this.delegate.renderJSON(requestData, value);
    }

    public void warmUp(List<FolderObject> folders2, ServerSession session) {
        List<Object> vals = this.delegate.getValues(folders2, session);
        int i = 0;
        for (FolderObject f : folders2) {
            String fn = f.getFullName();
            Object value = vals.get(i++);
            this.values.put(fn == null ? Integer.toString(f.getObjectID()) : fn, null == value ? NULL : value);
        }
    }
}

