/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DelegateFileHolder
implements IFileHolder {
    private final IFileHolder fileHolder;
    private InputStream stream;
    private IFileHolder.InputStreamClosure streamProvider;
    private Long length;
    private int repetitive = -1;

    public DelegateFileHolder(IFileHolder fileHolder) {
        this.fileHolder = fileHolder;
        this.length = null;
    }

    public List<Runnable> getPostProcessingTasks() {
        return this.fileHolder.getPostProcessingTasks();
    }

    public void addPostProcessingTask(Runnable task) {
        this.fileHolder.addPostProcessingTask(task);
    }

    public boolean repetitive() {
        int repetitive = this.repetitive;
        if (repetitive < 0) {
            return this.fileHolder.repetitive();
        }
        return repetitive > 0;
    }

    public void close() throws IOException {
        Streams.close((Closeable[])new Closeable[]{this.stream, this.fileHolder});
    }

    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        return this.fileHolder.getRandomAccess();
    }

    public InputStream getStream() throws OXException {
        InputStream stream = this.stream;
        if (null != stream) {
            return stream;
        }
        IFileHolder.InputStreamClosure streamProvider = this.streamProvider;
        if (null != streamProvider) {
            try {
                return streamProvider.newStream();
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        return this.fileHolder.getStream();
    }

    public DelegateFileHolder setStream(InputStream stream, long length) {
        this.stream = stream;
        this.length = length;
        this.repetitive = 0;
        return this;
    }

    public DelegateFileHolder setStream(IFileHolder.InputStreamClosure streamProvider, long length) {
        this.streamProvider = streamProvider;
        this.length = length;
        this.repetitive = 1;
        return this;
    }

    public DelegateFileHolder setLength(long length) {
        this.length = length;
        return this;
    }

    public long getLength() {
        Long length = this.length;
        if (length != null) {
            return length;
        }
        return this.fileHolder.getLength();
    }

    public String getContentType() {
        return this.fileHolder.getContentType();
    }

    public String getName() {
        return this.fileHolder.getName();
    }

    public String getDisposition() {
        return this.fileHolder.getDisposition();
    }

    public String getDelivery() {
        return this.fileHolder.getDelivery();
    }
}

