/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.fileholder.ByteArrayRandomAccess;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public final class ByteArrayFileHolder
implements IFileHolder {
    private final byte[] bytes;
    private String name;
    private String contentType;
    private String disposition;
    private String delivery;
    private final List<Runnable> tasks;

    public ByteArrayFileHolder(byte[] bytes) {
        this.bytes = bytes;
        this.contentType = "application/octet-stream";
        this.tasks = new LinkedList<Runnable>();
    }

    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    public boolean repetitive() {
        return true;
    }

    public void close() {
    }

    public InputStream getStream() {
        return new UnsynchronizedByteArrayInputStream(this.bytes);
    }

    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        return new ByteArrayRandomAccess(this.bytes);
    }

    public long getLength() {
        return this.bytes.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    public String getDelivery() {
        return this.delivery;
    }
}

