/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum PublicationErrorMessage implements DisplayableOXExceptionCode
{
    SQL_ERROR(CATEGORY_ERROR, 1, "A SQL error occurred.", "Error while reading/writing data from/to the database."),
    PARSE_EXCEPTION(CATEGORY_ERROR, 2, "A parsing error occurred: %1$s."),
    NO_LOADER_FOUND_EXCEPTION(CATEGORY_ERROR, 3, "Could not load publications of type %1$s"),
    ID_GIVEN_EXCEPTION(CATEGORY_ERROR, 4, "Unable to save a given ID."),
    PUBLICATION_NOT_FOUND_EXCEPTION(CATEGORY_USER_INPUT, 5, "Cannot find the publication site.", "Cannot find the requested publication site."),
    UNIQUENESS_CONSTRAINT_VIOLATION_EXCEPTION(CATEGORY_USER_INPUT, 6, "%1$s has already been taken (field: %2$s)"),
    ACCESS_DENIED_EXCEPTION(CATEGORY_PERMISSION_DENIED, 7, "You do not have the permissions to perform the chosen action (%s)", "You do not have the appropriate permissions to perform the chosen action."),
    NOT_FOUND_EXCEPTION(CATEGORY_PERMISSION_DENIED, 8, "The published document has been deleted in the meantime and therefore is no longer available.", "The published document has been deleted in the meantime and therefore is no longer available.");

    private static final String SQL_EXCEPTION_MSG = "A SQL error occurred.";
    private static final String PARSE_EXCEPTION_MSG = "A parsing error occurred: %1$s.";
    private static final String NO_LOADER_FOUND_MSG = "Could not load publications of type %1$s";
    private static final String ID_GIVEN_MSG = "Unable to save a given ID.";
    private static final String PUBLICATION_NOT_FOUND_MSG = "Cannot find the publication site.";
    private static final String UNIQUENESS_CONSTRAINT_VIOLATION = "%1$s has already been taken (field: %2$s)";
    private static final String ACCESS_DENIED_MSG = "You do not have the permissions to perform the chosen action (%s)";
    private static final String NOT_FOUND_MSG = "The published document has been deleted in the meantime and therefore is no longer available.";
    private Category category;
    private int errorCode;
    private String message;
    private String displayMessage;

    private PublicationErrorMessage(Category category, int errorCode, String message) {
        this(category, errorCode, message, null);
    }

    private PublicationErrorMessage(Category category, int errorCode, String message, String displayMessage) {
        this.category = category;
        this.errorCode = errorCode;
        this.message = message;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
    }

    public String getPrefix() {
        return "PUB";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

