/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceRegistry
implements ServiceLookup {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<Class<?>, Object> services;

    public ServiceRegistry() {
        this(16);
    }

    public ServiceRegistry(int initialCapacity) {
        this.services = new ConcurrentHashMap(initialCapacity, 0.9f, 1);
    }

    public void clearRegistry() {
        this.services.clear();
    }

    public void removeService(Class<?> clazz) {
        this.services.remove(clazz);
    }

    public <S> void addService(Class<? extends S> clazz, S service) {
        this.services.put(clazz, service);
    }

    public <S> S getService(Class<? extends S> clazz) {
        Object service = this.services.get(clazz);
        if (null == service) {
            return null;
        }
        return clazz.cast(service);
    }

    public <S> S getOptionalService(Class<? extends S> clazz) {
        return this.getService(clazz);
    }

    public <S> S getService(Class<? extends S> clazz, boolean errorOnAbsence) throws OXException {
        Object service = this.services.get(clazz);
        if (null == service) {
            if (errorOnAbsence) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{clazz.getName()});
            }
            return null;
        }
        return clazz.cast(service);
    }

    public int size() {
        return this.services.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Service registry:\n");
        if (this.services.isEmpty()) {
            sb.append("<empty>");
        } else {
            Iterator<Map.Entry<Class<?>, Object>> iter = this.services.entrySet().iterator();
            while (true) {
                Map.Entry<Class<?>, Object> e = iter.next();
                sb.append(e.getKey().getName()).append(": ").append(e.getValue().toString());
                if (!iter.hasNext()) break;
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

