/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.atomic.AtomicReference;

public class ExceptionAwarePipedInputStream
extends PipedInputStream {
    private final AtomicReference<IOException> exception = new AtomicReference();

    public ExceptionAwarePipedInputStream() {
    }

    public ExceptionAwarePipedInputStream(int pipeSize) {
        super(pipeSize);
    }

    public ExceptionAwarePipedInputStream(PipedOutputStream src, int pipeSize) throws IOException {
        super(src, pipeSize);
    }

    public ExceptionAwarePipedInputStream(PipedOutputStream src) throws IOException {
        super(src);
    }

    @Override
    public synchronized int available() throws IOException {
        IOException exception = this.exception.get();
        if (exception != null) {
            throw exception;
        }
        return super.available();
    }

    @Override
    public synchronized int read() throws IOException {
        IOException exception = this.exception.get();
        if (exception != null) {
            throw exception;
        }
        return super.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        IOException exception = this.exception.get();
        if (exception != null) {
            throw exception;
        }
        return super.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        IOException exception = this.exception.get();
        if (exception != null) {
            throw exception;
        }
        super.close();
    }

    public void setException(Exception e) {
        this.exception.set(e instanceof IOException ? (IOException)e : new IOException("Error while writing to connected OutputStream", e));
    }
}

