/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.id;

import com.openexchange.java.Charsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class IDMangler {
    public static final String PRIMARY_DELIM = "://";
    private static final char CHAR_SECONDARY_DELIM = '/';
    public static final String SECONDARY_DELIM;
    private static final BitSet PRINTABLE_CHARS;

    public static String mangle(String ... components) {
        StringBuilder id = new StringBuilder(50);
        boolean first = true;
        for (String component : components) {
            component = IDMangler.escape(component);
            id.append(component);
            String delim = first ? PRIMARY_DELIM : SECONDARY_DELIM;
            id.append(delim);
            first = false;
        }
        id.setLength(id.length() - 1);
        return id.toString();
    }

    private static String escape(String string) {
        if (string == null) {
            return null;
        }
        return IDMangler.encodeQP(string);
    }

    public static List<String> unmangle(String mangled) {
        if (null == mangled) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(5);
        int prev = 0;
        int pos = mangled.indexOf(PRIMARY_DELIM, prev);
        if (pos < 0) {
            pos = mangled.indexOf(47, prev);
            if (pos <= 0) {
                list.add(mangled);
            } else {
                list.add(IDMangler.decodeQP(mangled.substring(prev, pos)));
                list.add(IDMangler.decodeQP(mangled.substring(pos + 1)));
            }
            return list;
        }
        list.add(IDMangler.decodeQP(mangled.substring(prev, pos)));
        prev = pos + PRIMARY_DELIM.length();
        while (prev > 0) {
            pos = mangled.indexOf(47, prev);
            if (pos > 0) {
                list.add(IDMangler.decodeQP(mangled.substring(prev, pos)));
                prev = pos + 1;
                continue;
            }
            list.add(IDMangler.decodeQP(mangled.substring(prev)));
            prev = -1;
        }
        return list;
    }

    private static String encodeQP(String string) {
        try {
            return Charsets.toAsciiString((byte[])QuotedPrintableCodec.encodeQuotedPrintable((BitSet)PRINTABLE_CHARS, (byte[])string.getBytes(Charsets.UTF_8)));
        }
        catch (UnsupportedCharsetException e) {
            return string;
        }
    }

    private static String decodeQP(String string) {
        try {
            return new String(QuotedPrintableCodec.decodeQuotedPrintable((byte[])Charsets.toAsciiBytes((String)string)), Charsets.UTF_8);
        }
        catch (DecoderException e) {
            return string;
        }
    }

    static {
        int i;
        SECONDARY_DELIM = Character.toString('/');
        BitSet bitSet = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            bitSet.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            bitSet.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            bitSet.set(i);
        }
        bitSet.set(46);
        bitSet.set(45);
        bitSet.set(95);
        PRINTABLE_CHARS = bitSet;
    }
}

