/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.interception.OXExceptionArguments;
import com.openexchange.exception.interception.OXExceptionInterceptor;
import com.openexchange.exception.interception.internal.OXExceptionInterceptorRegistration;
import com.openexchange.log.LogProperties;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class OXExceptionFactory {
    private static final OXExceptionFactory INSTANCE = new OXExceptionFactory();
    public static final Set<Category.EnumType> DISPLAYABLE = Collections.unmodifiableSet(EnumSet.of(Category.EnumType.CAPACITY, new Category.EnumType[]{Category.EnumType.CONFLICT, Category.EnumType.CONNECTIVITY, Category.EnumType.PERMISSION_DENIED, Category.EnumType.SERVICE_DOWN, Category.EnumType.TRUNCATED, Category.EnumType.TRY_AGAIN, Category.EnumType.USER_INPUT, Category.EnumType.WARNING}));

    public static OXExceptionFactory getInstance() {
        return INSTANCE;
    }

    private OXExceptionFactory() {
    }

    public boolean equals(OXExceptionCode code, OXException e) {
        return OXExceptionFactory.recEquals(code.getPrefix(), code.getNumber(), e);
    }

    private static boolean recEquals(String prefix, int code, OXException e) {
        if (e.getCode() == code && prefix.equals(e.getPrefix())) {
            return true;
        }
        Throwable cause = e.getCause();
        if (!(cause instanceof OXException)) {
            return false;
        }
        return OXExceptionFactory.recEquals(prefix, code, (OXException)cause);
    }

    public OXException create(OXExceptionCode code) {
        return this.create(code, new Object[0]);
    }

    public OXException create(OXExceptionCode code, Object ... args) {
        return this.create(code, (Throwable)null, args);
    }

    public OXException create(OXExceptionCode code, Throwable cause, Object ... args) {
        return this.create(code, null, cause, args);
    }

    public OXException create(OXExceptionCode code, Category category, Throwable cause, Object ... args) {
        return this.create(code, category, cause, true, args);
    }

    private OXException create(OXExceptionCode code, Category category, Throwable cause, boolean intercept, Object ... args) {
        OXException ret;
        Category cat;
        Category category2 = cat = null == category ? code.getCategory() : category;
        if (DisplayableOXExceptionCode.class.isInstance(code)) {
            ret = new OXException(code.getNumber(), ((DisplayableOXExceptionCode)code).getDisplayMessage(), cause, args).setLogMessage(code.getMessage(), args);
        } else if (cat.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new OXException(code.getNumber(), code.getMessage(), cause, args);
        } else if (DISPLAYABLE.contains(cat.getType())) {
            ret = new OXException(code.getNumber(), code.getMessage(), cause, args).setLogMessage(code.getMessage(), args);
        } else {
            String displayMessage = Category.EnumType.TRY_AGAIN.equals(cat.getType()) ? "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later." : "An error occurred inside the server which prevented it from fulfilling the request.";
            ret = new OXException(code.getNumber(), displayMessage, cause, new Object[0]).setLogMessage(code.getMessage(), args);
        }
        ret.addCategory(cat).setPrefix(code.getPrefix()).setExceptionCode(code);
        if (intercept) {
            String module = LogProperties.getLogProperty(LogProperties.Name.AJAX_MODULE);
            String action = LogProperties.getLogProperty(LogProperties.Name.AJAX_ACTION);
            List<OXExceptionInterceptor> interceptors = OXExceptionInterceptorRegistration.getInstance().getResponsibleInterceptors(module, action);
            for (OXExceptionInterceptor interceptor : interceptors) {
                OXExceptionArguments newArgs = interceptor.intercept(ret);
                if (null == newArgs) continue;
                ret = this.create(newArgs.getCode(), newArgs.getCategory(), newArgs.getCause(), false, newArgs.getArgs());
            }
        }
        return ret;
    }
}

