/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.ziputil.ZipMaker;
import com.openexchange.java.Strings;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public class ZipDocumentsAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        List<IdVersionPair> idVersionPairs;
        String value = request.getParameter("body");
        if (Strings.isEmpty((String)value)) {
            idVersionPairs = request.getIdVersionPairs();
        } else {
            try {
                JSONArray jsonArray = new JSONArray(value);
                int len = jsonArray.length();
                idVersionPairs = new ArrayList<IdVersionPair>(len);
                for (int i = 0; i < len; ++i) {
                    JSONObject tuple = jsonArray.getJSONObject(i);
                    String id = tuple.optString(AbstractFileAction.Param.ID.getName(), null);
                    String folderId = tuple.optString(AbstractFileAction.Param.FOLDER_ID.getName(), null);
                    String version = tuple.optString(AbstractFileAction.Param.VERSION.getName(), FileStorageFileAccess.CURRENT_VERSION);
                    if (null == id && null == folderId) {
                        throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{"body", "Invalid resource identifier: " + tuple});
                    }
                    idVersionPairs.add(new IdVersionPair(id, version, folderId));
                }
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create((Throwable)e, new Object[]{"body", e.getMessage()});
            }
        }
        String tmp = request.getParameter("recursive");
        boolean recursive = AJAXRequestDataTools.parseBoolParameter((String)tmp);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        IDBasedFolderAccess folderAccess = request.getFolderAccess();
        ZipMaker zipMaker = new ZipMaker(idVersionPairs, recursive, fileAccess, folderAccess);
        zipMaker.checkThreshold(ZipDocumentsAction.threshold());
        AJAXRequestData ajaxRequestData = request.getRequestData();
        if (ajaxRequestData.setResponseHeader("Content-Type", "application/zip")) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("attachment");
            DownloadUtility.appendFilenameParameter((String)"documents.zip", (String)"application/zip", (String)ajaxRequestData.getUserAgent(), (StringBuilder)sb);
            ajaxRequestData.setResponseHeader("Content-Disposition", sb.toString());
            try {
                zipMaker.writeZipArchive(ajaxRequestData.optOutputStream());
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
        }
        ThresholdFileHolder fileHolder = new ThresholdFileHolder();
        fileHolder.setDisposition("attachment");
        fileHolder.setName("documents.zip");
        fileHolder.setContentType("application/zip");
        fileHolder.setDelivery("download");
        zipMaker.writeZipArchive(fileHolder.asOutputStream());
        ajaxRequestData.setFormat("file");
        return new AJAXRequestResult((Object)fileHolder, "file");
    }
}

