/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.java.Strings;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.ArrayList;
import java.util.Date;

@Actions(value={@Action(method=RequestMethod.PUT, name="new", description="Create an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included.", responseDescription="FolderID/ObjectID of the newly created infoitem."), @Action(method=RequestMethod.POST, name="new", description="Create an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="FolderID/ObjectID of the newly created infoitem. The response is sent as a HTML document (see introduction).")})
public class NewAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.requireFileMetadata();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        File file = request.getFile();
        if (Strings.isEmpty((String)file.getFolderId())) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(new Object[]{"folder"});
        }
        file.setId(FileStorageFileAccess.NEW);
        boolean ignoreWarnings = AJAXRequestDataTools.parseBoolParameter((String)"ignoreWarnings", (AJAXRequestData)request.getRequestData(), (boolean)false);
        String newId = request.hasUploads() ? fileAccess.saveDocument(file, request.getUploadedFileData(), -1L, request.getSentColumns(), false, ignoreWarnings) : fileAccess.saveFileMetadata(file, -1L, request.getSentColumns(), ignoreWarnings);
        ArrayList<OXException> warnings = new ArrayList<OXException>(fileAccess.getAndFlushWarnings());
        if (request.notifyPermissionEntities() && file.getObjectPermissions() != null && file.getObjectPermissions().size() > 0) {
            File modified = fileAccess.getFileMetadata(newId, FileStorageFileAccess.CURRENT_VERSION);
            warnings.addAll(this.sendNotifications(request.getNotificationTransport(), request.getNotifiactionMessage(), null, modified, (Session)request.getSession(), request.getRequestData().getHostData()));
        }
        AJAXRequestResult result = null != newId && request.extendedResponse() ? this.result(fileAccess.getFileMetadata(newId, FileStorageFileAccess.CURRENT_VERSION), request) : new AJAXRequestResult((Object)newId, new Date(file.getSequenceNumber()));
        result.addWarnings(warnings);
        if (null == newId && null != warnings && !warnings.isEmpty() && !ignoreWarnings) {
            String name = NewAction.getFilenameSave(file, null, fileAccess);
            result.setException(FileStorageExceptionCodes.FILE_SAVE_ABORTED.create(new Object[]{name, name}));
        }
        return result;
    }
}

