/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AllAction;
import com.openexchange.file.storage.json.actions.files.CopyAction;
import com.openexchange.file.storage.json.actions.files.DeleteAction;
import com.openexchange.file.storage.json.actions.files.DetachAction;
import com.openexchange.file.storage.json.actions.files.DocumentAction;
import com.openexchange.file.storage.json.actions.files.DocumentDeltaAction;
import com.openexchange.file.storage.json.actions.files.DocumentPatchAction;
import com.openexchange.file.storage.json.actions.files.DocumentSigAction;
import com.openexchange.file.storage.json.actions.files.GetAction;
import com.openexchange.file.storage.json.actions.files.ListAction;
import com.openexchange.file.storage.json.actions.files.LockAction;
import com.openexchange.file.storage.json.actions.files.NewAction;
import com.openexchange.file.storage.json.actions.files.NotifyAction;
import com.openexchange.file.storage.json.actions.files.RevertAction;
import com.openexchange.file.storage.json.actions.files.SaveAsAction;
import com.openexchange.file.storage.json.actions.files.SearchAction;
import com.openexchange.file.storage.json.actions.files.SharesAction;
import com.openexchange.file.storage.json.actions.files.UnlockAction;
import com.openexchange.file.storage.json.actions.files.UpdateAction;
import com.openexchange.file.storage.json.actions.files.UpdatesAction;
import com.openexchange.file.storage.json.actions.files.VersionsAction;
import com.openexchange.file.storage.json.actions.files.ZipDocumentsAction;
import com.openexchange.file.storage.json.actions.files.ZipFolderAction;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="infostore", description="The infostore module combines the knowledge database, bookmarks and documents.")
public class FileActionFactory
implements AJAXActionServiceFactory {
    public static FileActionFactory INSTANCE = new FileActionFactory();
    private final Map<String, AJAXActionService> actions;

    protected FileActionFactory() {
        ConcurrentHashMap<String, AbstractFileAction> actions = new ConcurrentHashMap<String, AbstractFileAction>(24, 0.9f, 1);
        actions.put("new", new NewAction());
        actions.put("update", new UpdateAction());
        actions.put("delete", new DeleteAction());
        actions.put("detach", new DetachAction());
        actions.put("revert", new RevertAction());
        actions.put("lock", new LockAction());
        actions.put("unlock", new UnlockAction());
        actions.put("copy", new CopyAction());
        actions.put("all", new AllAction());
        actions.put("updates", new UpdatesAction());
        actions.put("list", new ListAction());
        actions.put("versions", new VersionsAction());
        actions.put("get", new GetAction());
        actions.put("search", new SearchAction());
        actions.put("shares", new SharesAction());
        actions.put("notify", new NotifyAction());
        actions.put("saveAs", new SaveAsAction());
        actions.put("document", new DocumentAction());
        actions.put("zipdocuments", new ZipDocumentsAction());
        actions.put("zipfolder", new ZipFolderAction());
        actions.put("documentdelta", new DocumentDeltaAction());
        actions.put("documentsig", new DocumentSigAction());
        actions.put("documentpatch", new DocumentPatchAction());
        this.actions = Collections.unmodifiableMap(actions);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    public AJAXActionService createActionService(String action) throws OXException {
        AJAXActionService handler = this.actions.get(action);
        if (handler == null) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(new Object[]{action});
        }
        return handler;
    }
}

