/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.UpdateAction;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.session.Session;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.share.notification.Entities;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.share.notification.ShareNotifyExceptionCodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteAction
extends AbstractFileAction {
    @Override
    protected void before(AJAXInfostoreRequest req) throws OXException {
        super.before(req);
        req.getFileAccess().startTransaction();
    }

    @Override
    protected void success(AJAXInfostoreRequest req, AJAXRequestResult result) throws OXException {
        req.getFileAccess().commit();
    }

    @Override
    protected void failure(AJAXInfostoreRequest req, Throwable throwable) throws OXException {
        req.getFileAccess().rollback();
    }

    @Override
    protected void after(AJAXInfostoreRequest req) {
        IDBasedFolderAccess folderAccess;
        IDBasedFileAccess fileAccess = req.optFileAccess();
        if (null != fileAccess) {
            try {
                fileAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != (folderAccess = req.optFolderAccess())) {
            try {
                folderAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.after(req);
    }

    protected static String getFilenameSave(File file, FileID id, IDBasedFileAccess fileAccess) {
        String name = file.getFileName();
        if (null != name) {
            return name;
        }
        name = file.getTitle();
        if (null != name) {
            return name;
        }
        if (null != id && null != fileAccess) {
            try {
                File metadata = fileAccess.getFileMetadata(id.toUniqueID(), FileStorageFileAccess.CURRENT_VERSION);
                if (null != metadata && null == (name = metadata.getFileName())) {
                    name = metadata.getTitle();
                }
            }
            catch (OXException e) {
                LoggerFactory.getLogger(UpdateAction.class).debug("Error getting name for file {}: {}", new Object[]{id, e.getMessage(), e});
            }
        }
        return name;
    }

    protected List<OXException> sendNotifications(ShareNotificationService.Transport transport, String message, File original, File modified, Session session, HostData hostData) {
        List<FileStorageObjectPermission> newPermissions;
        List<FileStorageObjectPermission> oldPermissions;
        if (hostData == null) {
            return Collections.singletonList(ShareNotifyExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"HostData was not available"}));
        }
        List<FileStorageObjectPermission> list = oldPermissions = original == null ? null : original.getObjectPermissions();
        if (oldPermissions == null) {
            oldPermissions = Collections.emptyList();
        }
        if ((newPermissions = modified.getObjectPermissions()) == null) {
            newPermissions = Collections.emptyList();
        }
        ArrayList<FileStorageObjectPermission> addedPermissions = new ArrayList<FileStorageObjectPermission>(newPermissions.size());
        for (FileStorageObjectPermission permission : newPermissions) {
            boolean isNew = true;
            for (FileStorageObjectPermission existing : oldPermissions) {
                if (existing.getEntity() != permission.getEntity() || existing.isGroup() != permission.isGroup()) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            addedPermissions.add(permission);
        }
        if (addedPermissions.isEmpty()) {
            return Collections.emptyList();
        }
        ShareNotificationService notificationService = Services.getShareNotificationService();
        if (notificationService == null) {
            return Collections.singletonList(ShareNotifyExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"ShareNotificationService was absent"}));
        }
        Entities entities = new Entities();
        for (FileStorageObjectPermission permission : addedPermissions) {
            if (permission.isGroup()) {
                entities.addGroup(permission.getEntity(), Entities.PermissionType.OBJECT, permission.getPermissions());
                continue;
            }
            entities.addUser(permission.getEntity(), Entities.PermissionType.OBJECT, permission.getPermissions());
        }
        return notificationService.sendShareCreatedNotifications(transport, entities, message, new ShareTargetPath(8, modified.getFolderId(), modified.getId()), session, hostData);
    }
}

