/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileAction.class);

    protected abstract AJAXRequestResult handle(InfostoreRequest var1) throws OXException;

    protected AJAXRequestResult result(File file, InfostoreRequest request) throws OXException {
        return new AJAXRequestResult((Object)file, new Date(file.getSequenceNumber()), "infostore");
    }

    protected AJAXRequestResult result(List<String> ids, InfostoreRequest request) throws OXException {
        try {
            JSONArray array = new JSONArray(ids.size());
            for (String id : ids) {
                JSONObject object = new JSONObject(4);
                object.put("id", (Object)id);
                object.put("folder", (Object)request.getFolderForID(id));
                array.put((Object)object);
            }
            return new AJAXRequestResult((Object)array);
        }
        catch (JSONException x) {
            throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getMessage()});
        }
    }

    public AJAXRequestResult result(String[] versions, long sequenceNumber, InfostoreRequest request) throws OXException {
        JSONArray array = new JSONArray(versions.length);
        for (String i : versions) {
            array.put((Object)i);
        }
        return new AJAXRequestResult((Object)array, new Date(sequenceNumber));
    }

    public AJAXRequestResult success(long sequenceNumber) {
        return new AJAXRequestResult((Object)Boolean.TRUE, new Date(sequenceNumber));
    }

    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        AJAXInfostoreRequest req = new AJAXInfostoreRequest(requestData, session);
        try {
            this.before(req);
            AJAXRequestResult result = this.handle(req);
            this.success(req, result);
            AJAXRequestResult aJAXRequestResult = result;
            return aJAXRequestResult;
        }
        catch (OXException x) {
            this.failure(req, x);
            throw x;
        }
        catch (NullPointerException e) {
            this.failure(req, e);
            LOG.error("", (Throwable)e);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{"Null dereference."});
        }
        catch (RuntimeException e) {
            this.failure(req, e);
            LOG.error("", (Throwable)e);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            this.after(req);
            requestData.cleanUploads();
        }
    }

    protected void after(AJAXInfostoreRequest req) {
        IDBasedFolderAccess folderAccess;
        IDBasedFileAccess fileAccess = req.optFileAccess();
        if (null != fileAccess) {
            try {
                fileAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != (folderAccess = req.optFolderAccess())) {
            try {
                folderAccess.finish();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void failure(AJAXInfostoreRequest req, Throwable throwable) throws OXException {
    }

    protected void success(AJAXInfostoreRequest req, AJAXRequestResult result) throws OXException {
    }

    protected void before(AJAXInfostoreRequest req) throws OXException {
    }

    protected static long threshold() {
        return FileStorageUtility.threshold();
    }

    public static int getZipDocumentsCompressionLevel() throws OXException {
        return FileStorageUtility.getZipDocumentsCompressionLevel();
    }

    public static enum Param {
        ID("id"),
        FOLDER_ID("folder"),
        VERSION("version"),
        COLUMNS("columns"),
        SORT("sort"),
        ORDER("order"),
        TIMEZONE("timezone"),
        TIMESTAMP("timestamp"),
        IGNORE("ignore"),
        DIFF("diff"),
        ATTACHED_ID("attached"),
        MODULE("module"),
        ATTACHMENT("attachment");

        private final String name;

        private Param(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

