/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.accounts;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.json.actions.accounts.AbstractFileStorageAccountAction;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class AllAction
extends AbstractFileStorageAccountAction {
    public AllAction(FileStorageServiceRegistry registry) {
        super(registry);
    }

    @Override
    protected AJAXRequestResult doIt(AJAXRequestData request, ServerSession session) throws JSONException, OXException {
        String fsServiceId = request.getParameter("filestorageService");
        ArrayList<FileStorageService> services = new ArrayList<FileStorageService>();
        if (fsServiceId != null) {
            services.add(this.registry.getFileStorageService(fsServiceId));
        } else {
            services.addAll(this.registry.getAllServices());
        }
        JSONArray result = new JSONArray();
        for (FileStorageService fsService : services) {
            List userAccounts = null;
            if (fsService instanceof AccountAware) {
                userAccounts = ((AccountAware)fsService).getAccounts((Session)session);
            }
            if (null == userAccounts) {
                userAccounts = fsService.getAccountManager().getAccounts((Session)session);
            }
            for (FileStorageAccount account : userAccounts) {
                FileStorageFolder rootFolder = fsService.getAccountAccess(account.getId(), (Session)session).getRootFolder();
                result.put((Object)this.writer.write(account, rootFolder));
            }
        }
        return new AJAXRequestResult((Object)result);
    }
}

