/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.customizer.file.AdditionalFileField;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.json.JsonFieldHandler;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.file.storage.json.osgi.FileFieldCollector;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataWriter {
    protected static final Logger LOG = LoggerFactory.getLogger(FileMetadataWriter.class);
    private final FileFieldCollector fieldCollector;

    public FileMetadataWriter(FileFieldCollector fieldCollector) {
        this.fieldCollector = fieldCollector;
    }

    public JSONObject write(AJAXInfostoreRequest request, File file) {
        JsonFieldHandler handler = new JsonFieldHandler(request);
        JSONObject jsonObject = (JSONObject)File.Field.inject((FileFieldHandler)FileMetadataWriter.getJsonHandler(file, handler), (Object)new JSONObject(), (Object[])new Object[0]);
        if (null != this.fieldCollector) {
            List<AdditionalFileField> additionalFields = this.fieldCollector.getFields();
            for (AdditionalFileField additionalField : additionalFields) {
                try {
                    Object value = additionalField.getValue((Object)file, request.getSession());
                    jsonObject.put(additionalField.getColumnName(), additionalField.renderJSON(request.getRequestData(), value));
                }
                catch (JSONException e) {
                    LOG.error("Error writing field: {}", (Object)additionalField.getColumnName(), (Object)e);
                }
            }
        }
        return jsonObject;
    }

    public JSONObject writeSpecific(AJAXInfostoreRequest request, File file, File.Field[] fields, int[] additionalColumns) {
        JSONObject jsonObject = new JSONObject();
        FileFieldHandler jsonHandler = FileMetadataWriter.getJsonHandler(file, new JsonFieldHandler(request));
        for (File.Field field : fields) {
            field.handle(jsonHandler, new Object[]{jsonObject});
        }
        if (null != this.fieldCollector && additionalColumns != null && additionalColumns.length > 0) {
            List<AdditionalFileField> additionalFields = this.fieldCollector.getFields(additionalColumns);
            for (AdditionalFileField additionalField : additionalFields) {
                try {
                    Object value = additionalField.getValue((Object)file, request.getSession());
                    jsonObject.put(additionalField.getColumnName(), additionalField.renderJSON(request.getRequestData(), value));
                }
                catch (JSONException e) {
                    LOG.error("Error writing field: {}", (Object)additionalField.getColumnName(), (Object)e);
                }
            }
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray write(AJAXInfostoreRequest request, SearchIterator<File> searchIterator) throws OXException {
        int[] columns = request.getRequestedColumns();
        List fields = File.Field.get((int[])columns);
        try {
            if (columns.length == fields.size()) {
                JsonFieldHandler handler = new JsonFieldHandler(request);
                JSONArray filesArray = new JSONArray(32);
                while (searchIterator.hasNext()) {
                    filesArray.put((Object)this.writeArray(handler, (File)searchIterator.next(), fields));
                }
                JSONArray jSONArray = filesArray;
                return jSONArray;
            }
            JSONArray jSONArray = this.write(request, SearchIterators.asList(searchIterator));
            return jSONArray;
        }
        finally {
            SearchIterators.close(searchIterator);
        }
    }

    public JSONArray write(AJAXInfostoreRequest request, List<File> files) throws OXException {
        List<AdditionalFileField> additionalFields;
        int[] columns = request.getRequestedColumns();
        HashMap<Integer, List> additionalFieldValues = null;
        if (null != this.fieldCollector && 0 < (additionalFields = this.fieldCollector.getFields(columns)).size()) {
            additionalFieldValues = new HashMap<Integer, List>(additionalFields.size());
            for (AdditionalFileField additionalField : additionalFields) {
                List values = additionalField.getValues(files, request.getSession());
                additionalFieldValues.put(additionalField.getColumnID(), values);
            }
        }
        JsonFieldHandler handler = new JsonFieldHandler(request);
        JSONArray filesArray = new JSONArray(files.size());
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            JSONArray fileArray = new JSONArray(columns.length);
            for (int column : columns) {
                List fieldValues;
                File.Field field = File.Field.get((int)column);
                if (null != field) {
                    fileArray.put(field.handle((FileFieldHandler)handler, new Object[]{file}));
                    continue;
                }
                List list = fieldValues = null != additionalFieldValues ? (List)additionalFieldValues.get(column) : null;
                if (null != fieldValues) {
                    fileArray.put(this.fieldCollector.getField(column).renderJSON(request.getRequestData(), fieldValues.get(i)));
                    continue;
                }
                fileArray.put(JSONObject.NULL);
            }
            filesArray.put((Object)fileArray);
        }
        return filesArray;
    }

    JSONArray writeArray(JsonFieldHandler handler, File f, List<File.Field> columns) {
        JSONArray array = new JSONArray(columns.size());
        for (File.Field field : columns) {
            array.put(field.handle((FileFieldHandler)handler, new Object[]{f}));
        }
        return array;
    }

    private static FileFieldHandler getJsonHandler(final File file, final JsonFieldHandler fieldHandler) {
        return new AbstractFileFieldHandler(){

            public Object handle(File.Field field, Object ... args) {
                JSONObject jsonObject = (JSONObject)this.get(0, JSONObject.class, args);
                try {
                    jsonObject.put(field.getName(), fieldHandler.handle(field, file));
                }
                catch (JSONException e) {
                    LOG.error("Error writing field: {}", (Object)field.getName(), (Object)e);
                }
                return jsonObject;
            }
        };
    }
}

