/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.file.storage.AbstractFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageObjectPermission;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultFile
extends AbstractFile {
    private static final String DEFAULT_TYPE = "application/octet-stream";
    private String categories;
    private int colorLabel;
    private String content;
    private Date created;
    private int createdBy;
    private String description;
    private String fileMD5Sum;
    private String fileMIMEType;
    private String fileName;
    private long fileSize;
    private String folderId;
    private String id;
    private Date lastModified;
    private Date lockedUntil;
    private int modifiedBy;
    private int numberOfVersions;
    private final Map<String, String> properties;
    private String title;
    private String url;
    private String version;
    private String versionComment;
    private boolean isCurrentVersion;
    private Map<String, Object> dynamicProperties;
    private List<FileStorageObjectPermission> objectPermissions;
    private boolean shareable;

    public DefaultFile() {
        this.fileMIMEType = DEFAULT_TYPE;
        this.properties = new HashMap<String, String>();
        this.dynamicProperties = new LinkedHashMap<String, Object>();
    }

    public DefaultFile(File file) {
        this.dynamicProperties = new LinkedHashMap<String, Object>();
        Set<String> propertyNames = file.getPropertyNames();
        HashMap<String, String> properties = new HashMap<String, String>(propertyNames.size());
        for (String propertyName : propertyNames) {
            properties.put(propertyName, file.getProperty(propertyName));
        }
        this.properties = properties;
        this.copyFrom(file);
    }

    @Override
    public String getCategories() {
        return this.categories;
    }

    @Override
    public int getColorLabel() {
        return this.colorLabel;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public int getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFileMD5Sum() {
        return this.fileMD5Sum;
    }

    @Override
    public String getFileMIMEType() {
        return this.fileMIMEType;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public String getFolderId() {
        return this.folderId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public Date getLockedUntil() {
        return this.lockedUntil;
    }

    @Override
    public int getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public int getNumberOfVersions() {
        return this.numberOfVersions;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public void setProperty(String name, String value) {
        if (null == value) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @Override
    public long getSequenceNumber() {
        if (this.lastModified == null) {
            return 0L;
        }
        return this.lastModified.getTime();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVersionComment() {
        return this.versionComment;
    }

    @Override
    public boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    @Override
    public boolean isShareable() {
        return this.shareable;
    }

    @Override
    public void setCategories(String categories) {
        this.categories = categories;
    }

    @Override
    public void setColorLabel(int color) {
        this.colorLabel = color;
    }

    @Override
    public void setCreated(Date creationDate) {
        this.created = creationDate;
    }

    @Override
    public void setCreatedBy(int creator) {
        this.createdBy = creator;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setFileMD5Sum(String sum) {
        this.fileMD5Sum = sum;
    }

    @Override
    public void setFileMIMEType(String type) {
        this.fileMIMEType = type;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setFileSize(long length) {
        this.fileSize = length;
    }

    @Override
    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setIsCurrentVersion(boolean bool) {
        this.isCurrentVersion = bool;
    }

    @Override
    public void setLastModified(Date now) {
        this.lastModified = now;
    }

    @Override
    public void setLockedUntil(Date lockedUntil) {
        this.lockedUntil = lockedUntil;
    }

    @Override
    public void setModifiedBy(int lastEditor) {
        this.modifiedBy = lastEditor;
    }

    @Override
    public void setNumberOfVersions(int numberOfVersions) {
        this.numberOfVersions = numberOfVersions;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setVersionComment(String string) {
        this.versionComment = string;
    }

    @Override
    public void setMeta(Map<String, Object> properties) {
        this.dynamicProperties = properties;
    }

    @Override
    public Map<String, Object> getMeta() {
        return this.dynamicProperties;
    }

    @Override
    public void setObjectPermissions(List<FileStorageObjectPermission> objectPermissions) {
        this.objectPermissions = objectPermissions;
    }

    @Override
    public List<FileStorageObjectPermission> getObjectPermissions() {
        return this.objectPermissions;
    }

    @Override
    public void setShareable(boolean shareable) {
        this.shareable = shareable;
    }
}

