/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.Document;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAdvancedSearchFileAccess;
import com.openexchange.file.storage.FileStorageEfficientRetrieval;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageExtendedMetadata;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageLockedFileAccess;
import com.openexchange.file.storage.FileStoragePersistentIDs;
import com.openexchange.file.storage.FileStorageRandomFileAccess;
import com.openexchange.file.storage.FileStorageRangeFileAccess;
import com.openexchange.file.storage.FileStorageSequenceNumberProvider;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.FileStorageVersionedFileAccess;
import com.openexchange.file.storage.ObjectPermissionAware;
import com.openexchange.file.storage.Range;
import com.openexchange.file.storage.infostore.FileMetadata;
import com.openexchange.file.storage.infostore.InfostoreFile;
import com.openexchange.file.storage.infostore.InfostoreSearchIterator;
import com.openexchange.file.storage.infostore.ToInfostoreTermVisitor;
import com.openexchange.file.storage.infostore.internal.FieldMapping;
import com.openexchange.file.storage.infostore.internal.InfostoreAccess;
import com.openexchange.file.storage.infostore.internal.InfostoreDeltaWrapper;
import com.openexchange.file.storage.infostore.internal.InfostoreDocument;
import com.openexchange.file.storage.infostore.internal.InfostoreTimedResult;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.file.storage.search.SearchTermVisitor;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentAndMetadata;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfostoreAdapterFileAccess
extends InfostoreAccess
implements FileStorageRandomFileAccess,
FileStorageSequenceNumberProvider,
FileStorageAdvancedSearchFileAccess,
FileStoragePersistentIDs,
FileStorageVersionedFileAccess,
FileStorageLockedFileAccess,
FileStorageEfficientRetrieval,
ObjectPermissionAware,
FileStorageRangeFileAccess,
FileStorageExtendedMetadata {
    private final InfostoreSearchEngine search;
    private final Context ctx;
    private final User user;
    private final ServerSession session;
    private final FileStorageAccountAccess accountAccess;
    private final int hash;

    public InfostoreAdapterFileAccess(ServerSession session, InfostoreFacade infostore, InfostoreSearchEngine search, FileStorageAccountAccess accountAccess) {
        super(infostore);
        this.session = session;
        this.ctx = session.getContext();
        this.user = session.getUser();
        this.search = search;
        this.accountAccess = accountAccess;
        int prime = 31;
        int result = 1;
        result = 31 * result + (accountAccess == null ? 0 : accountAccess.getAccountId().hashCode());
        result = 31 * result + (this.ctx == null ? 0 : this.ctx.getContextId());
        this.hash = result = 31 * result + (this.user == null ? 0 : this.user.getId());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InfostoreAdapterFileAccess)) {
            return false;
        }
        InfostoreAdapterFileAccess other = (InfostoreAdapterFileAccess)obj;
        if (this.accountAccess == null ? other.accountAccess != null : !this.accountAccess.getAccountId().equals(other.accountAccess.getAccountId())) {
            return false;
        }
        if (this.ctx == null ? other.ctx != null : this.ctx.getContextId() != other.ctx.getContextId()) {
            return false;
        }
        return !(this.user == null ? other.user != null : this.user.getId() != other.user.getId());
    }

    public boolean exists(String folderId, String id, String version) throws OXException {
        try {
            return this.getInfostore(folderId).exists(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.session);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public InputStream getDocument(String folderId, String id, String version) throws OXException {
        try {
            return this.getInfostore(folderId).getDocument(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.session);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public InputStream getDocument(String folderId, String id, String version, long offset, long length) throws OXException {
        try {
            return this.getInfostore(folderId).getDocument(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), offset, length, this.session);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public File getFileMetadata(String folderId, String id, String version) throws OXException {
        try {
            DocumentMetadata metadata;
            if (null == folderId) {
                metadata = this.getInfostore(folderId).getDocumentMetadata(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.session);
            } else {
                metadata = this.getInfostore(folderId).getDocumentMetadata(InfostoreAdapterFileAccess.FOLDERID(folderId), InfostoreAdapterFileAccess.ID(id), null == version ? -1 : Integer.parseInt(version), this.session);
                if (0L < metadata.getFolderId() && !folderId.equals(Long.toString(metadata.getFolderId()))) {
                    throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
                }
            }
            return new InfostoreFile(metadata);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public Document getDocumentAndMetadata(String folderId, String id, String version) throws OXException {
        return this.getDocumentAndMetadata(folderId, id, version, null);
    }

    public Document getDocumentAndMetadata(String folderId, String id, String version, String clientETag) throws OXException {
        try {
            DocumentAndMetadata document;
            if (null == folderId) {
                document = this.getInfostore(folderId).getDocumentAndMetadata(InfostoreAdapterFileAccess.ID(id), null == version ? -1 : InfostoreAdapterFileAccess.ID(version), clientETag, this.session);
            } else {
                long documentFolderId;
                document = this.getInfostore(folderId).getDocumentAndMetadata(InfostoreAdapterFileAccess.FOLDERID(folderId), InfostoreAdapterFileAccess.ID(id), null == version ? -1 : InfostoreAdapterFileAccess.ID(version), clientETag, this.session);
                long l = documentFolderId = null != document.getMetadata() ? document.getMetadata().getFolderId() : 0L;
                if (0L < documentFolderId && !folderId.equals(String.valueOf(documentFolderId))) {
                    throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
                }
            }
            return new InfostoreDocument(document);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public void lock(String folderId, String id, long diff) throws OXException {
        try {
            this.getInfostore(folderId).lock(InfostoreAdapterFileAccess.ID(id), diff, this.session);
        }
        catch (NumberFormatException e) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create((Throwable)e, new Object[]{id, folderId});
        }
    }

    public void removeDocument(String folderId, long sequenceNumber) throws OXException {
        this.getInfostore(folderId).removeDocument(InfostoreAdapterFileAccess.FOLDERID(folderId), sequenceNumber, this.session);
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber) throws OXException {
        return this.removeDocument(ids, sequenceNumber, false);
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber, boolean hardDelete) throws OXException {
        int[] infostoreIDs = new int[ids.size()];
        HashMap<Integer, FileStorageFileAccess.IDTuple> id2folder = new HashMap<Integer, FileStorageFileAccess.IDTuple>(ids.size());
        for (int i = 0; i < infostoreIDs.length; ++i) {
            FileStorageFileAccess.IDTuple tuple = ids.get(i);
            infostoreIDs[i] = InfostoreAdapterFileAccess.ID(tuple.getId());
            id2folder.put(infostoreIDs[i], tuple);
        }
        InfostoreFacade infostore = this.getInfostore(null);
        ArrayList conflicted = null;
        if (hardDelete) {
            conflicted = infostore.removeDocument(ids, sequenceNumber, this.session);
        } else {
            String trashFolderID = this.getTrashFolderID();
            if (null == trashFolderID) {
                conflicted = infostore.removeDocument(ids, sequenceNumber, this.session);
            } else {
                FileStorageFolderAccess folderAccess = this.getAccountAccess().getFolderAccess();
                String rootFolderID = folderAccess.getRootFolder().getId();
                ArrayList<FileStorageFileAccess.IDTuple> filesToDelete = new ArrayList<FileStorageFileAccess.IDTuple>();
                ArrayList<FileStorageFileAccess.IDTuple> filesToMove = new ArrayList<FileStorageFileAccess.IDTuple>();
                HashMap<String, FileStorageFolder> knownFolders = new HashMap<String, FileStorageFolder>();
                for (FileStorageFileAccess.IDTuple tuple : ids) {
                    String folderID = tuple.getFolder();
                    while (null != folderID && !trashFolderID.equals(folderID) && !rootFolderID.equals(folderID)) {
                        FileStorageFolder folder = (FileStorageFolder)knownFolders.get(folderID);
                        if (null == folder) {
                            folder = folderAccess.getFolder(folderID);
                            knownFolders.put(folderID, folder);
                        }
                        folderID = folder.getParentId();
                    }
                    if (trashFolderID.equals(folderID)) {
                        filesToDelete.add(tuple);
                        continue;
                    }
                    filesToMove.add(tuple);
                }
                if (0 < filesToDelete.size()) {
                    conflicted = infostore.removeDocument(filesToDelete, sequenceNumber, this.session);
                }
                if (0 < filesToMove.size()) {
                    List conflicted2 = infostore.moveDocuments(this.session, filesToMove, sequenceNumber, trashFolderID, true);
                    if (null == conflicted || 0 == conflicted.size()) {
                        conflicted = conflicted2;
                    } else if (null != conflicted2 && 0 < conflicted2.size()) {
                        ArrayList temp = new ArrayList(conflicted.size() + conflicted2.size());
                        temp.addAll(conflicted);
                        temp.addAll(conflicted2);
                        conflicted = temp;
                    }
                }
            }
        }
        return conflicted;
    }

    public String[] removeVersion(String folderId, String id, String[] versions) throws OXException {
        return InfostoreAdapterFileAccess.toStrings(this.getInfostore(folderId).removeVersion(InfostoreAdapterFileAccess.ID(id), InfostoreAdapterFileAccess.parseInts(versions), this.session));
    }

    private static int[] parseInts(String[] sa) {
        if (null == sa) {
            return null;
        }
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            String version = sa[i];
            ret[i] = null == version ? -1 : Integer.parseInt(version);
        }
        return ret;
    }

    private static String[] toStrings(int[] ia) {
        if (null == ia) {
            return null;
        }
        String[] ret = new String[ia.length];
        for (int i = 0; i < ia.length; ++i) {
            int iVersion = ia[i];
            ret[i] = iVersion < 0 ? null : Integer.toString(iVersion);
        }
        return ret;
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber) throws OXException {
        FileStorageUtility.checkUrl((File)file);
        return this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, this.session);
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        return this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), this.session);
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields, boolean ignoreVersion) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        return this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), ignoreVersion, this.session);
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields, long offset) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        return this.getInfostore(file.getFolderId()).saveDocument((DocumentMetadata)new FileMetadata(file), data, sequenceNumber, FieldMapping.getMatching(modifiedFields), offset, this.session);
    }

    public FileStorageFileAccess.IDTuple saveFileMetadata(File file, long sequenceNumber) throws OXException {
        FileStorageUtility.checkUrl((File)file);
        return this.getInfostore(file.getFolderId()).saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, this.session);
    }

    public FileStorageFileAccess.IDTuple saveFileMetadata(File file, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        if (modifiedFields.contains(File.Field.URL)) {
            FileStorageUtility.checkUrl((File)file);
        }
        return this.getInfostore(file.getFolderId()).saveDocumentMetadata((DocumentMetadata)new FileMetadata(file), sequenceNumber, FieldMapping.getMatching(modifiedFields), this.session);
    }

    public void touch(String folderId, String id) throws OXException {
        this.getInfostore(folderId).touch(InfostoreAdapterFileAccess.ID(id), this.session);
    }

    public void unlock(String folderId, String id) throws OXException {
        this.getInfostore(folderId).unlock(InfostoreAdapterFileAccess.ID(id), this.session);
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, boolean ignoreDeleted) throws OXException {
        Delta delta = this.getInfostore(folderId).getDelta(InfostoreAdapterFileAccess.FOLDERID(folderId), updateSince, FieldMapping.getMatching(fields), ignoreDeleted, this.session);
        return new InfostoreDeltaWrapper((Delta<DocumentMetadata>)delta);
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, boolean ignoreDeleted) throws OXException {
        Delta delta = this.getInfostore(folderId).getDelta(InfostoreAdapterFileAccess.FOLDERID(folderId), updateSince, FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), ignoreDeleted, this.session);
        return new InfostoreDeltaWrapper((Delta<DocumentMetadata>)delta);
    }

    public Map<String, Long> getSequenceNumbers(List<String> folderIds) throws OXException {
        HashMap<String, Long> sequenceNumbers = new HashMap<String, Long>(folderIds.size());
        ArrayList<Long> foldersToQuery = new ArrayList<Long>(folderIds.size());
        for (String folderId : folderIds) {
            Long id = Long.valueOf(folderId);
            if (VIRTUAL_FOLDERS.contains(id)) {
                sequenceNumbers.put(folderId, 0L);
                continue;
            }
            foldersToQuery.add(id);
        }
        if (0 < foldersToQuery.size()) {
            Map infostoreNumbers = this.infostore.getSequenceNumbers(foldersToQuery, true, this.session);
            for (Map.Entry entry : infostoreNumbers.entrySet()) {
                sequenceNumbers.put(String.valueOf((Long)entry.getKey()), (Long)entry.getValue());
            }
        }
        return sequenceNumbers;
    }

    public TimedResult<File> getDocuments(String folderId) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), FieldMapping.getMatching(fields), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, Range range) throws OXException {
        if (null == range) {
            return this.getDocuments(folderId, fields, sort, order);
        }
        TimedResult documents = this.getInfostore(folderId).getDocuments(InfostoreAdapterFileAccess.FOLDERID(folderId), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), range.from, range.to, this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
    }

    public TimedResult<File> getDocuments(List<FileStorageFileAccess.IDTuple> ids, List<File.Field> fields) throws OXException {
        try {
            TimedResult documents = this.getInfostore(null).getDocuments(ids, FieldMapping.getMatching(fields), this.session);
            return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents);
        }
        catch (IllegalAccessException e) {
            throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public SearchIterator<File> getUserSharedDocuments(List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        TimedResult documents = this.getInfostore(null).getUserSharedDocuments(FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), -1, -1, this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)documents).results();
    }

    public TimedResult<File> getVersions(String folderId, String id) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), FieldMapping.getMatching(fields), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        TimedResult versions = this.getInfostore(folderId).getVersions(InfostoreAdapterFileAccess.ID(id), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), this.session);
        return new InfostoreTimedResult((TimedResult<DocumentMetadata>)versions);
    }

    public SearchIterator<File> search(String pattern, List<File.Field> fields, String folderId, File.Field sort, FileStorageFileAccess.SortDirection order, int start, int end) throws OXException {
        int folder = folderId == null ? -10 : Integer.parseInt(folderId);
        return new InfostoreSearchIterator((SearchIterator<DocumentMetadata>)this.search.search(this.session, pattern, folder, FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), start, end));
    }

    public SearchIterator<File> search(List<String> folderIds, SearchTerm<?> searchTerm, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, int start, int end) throws OXException {
        TIntArrayList fids = new TIntArrayList(null == folderIds ? 0 : folderIds.size());
        if (null != folderIds) {
            for (String folderId : folderIds) {
                try {
                    fids.add(Integer.parseInt(folderId));
                }
                catch (NumberFormatException e) {
                    throw FileStorageExceptionCodes.INVALID_FOLDER_IDENTIFIER.create(new Object[]{folderId});
                }
            }
        }
        ToInfostoreTermVisitor visitor = new ToInfostoreTermVisitor();
        searchTerm.visit((SearchTermVisitor)visitor);
        return new InfostoreSearchIterator((SearchIterator<DocumentMetadata>)this.search.search(this.session, visitor.getInfostoreTerm(), fids.toArray(), FieldMapping.getMatching(fields), FieldMapping.getMatching(sort), FieldMapping.getSortDirection(order), start, end));
    }

    public void commit() throws OXException {
        this.infostore.commit();
    }

    public void finish() throws OXException {
        this.infostore.finish();
    }

    public void rollback() throws OXException {
        this.infostore.rollback();
    }

    public void setCommitsTransaction(boolean commits) {
        this.infostore.setCommitsTransaction(commits);
    }

    public void setRequestTransactional(boolean transactional) {
        this.infostore.setRequestTransactional(transactional);
    }

    public void setTransactional(boolean transactional) {
        this.infostore.setTransactional(transactional);
    }

    public void startTransaction() throws OXException {
        this.infostore.startTransaction();
    }

    public FileStorageAccountAccess getAccountAccess() {
        return this.accountAccess;
    }

    public FileStorageFileAccess.IDTuple copy(FileStorageFileAccess.IDTuple source, String version, String destFolder, File update, InputStream newFile, List<File.Field> modifiedFields) throws OXException {
        File orig = this.getFileMetadata(source.getFolder(), source.getId(), version);
        InputStream in = newFile;
        if (in == null && orig.getFileName() != null) {
            in = this.getDocument(source.getFolder(), source.getId(), version);
        }
        if (update != null) {
            orig.copyFrom(update, modifiedFields.toArray(new File.Field[modifiedFields.size()]));
            if (!modifiedFields.contains(File.Field.CREATED)) {
                orig.setCreated(null);
            }
        }
        orig.setId(NEW);
        orig.setFolderId(destFolder);
        if (in == null) {
            this.saveFileMetadata(orig, -1L);
        } else {
            this.saveDocument(orig, in, -1L);
        }
        return new FileStorageFileAccess.IDTuple(destFolder, orig.getId());
    }

    public FileStorageFileAccess.IDTuple move(FileStorageFileAccess.IDTuple source, String destFolder, long sequenceNumber, File update, List<File.Field> modifiedFields) throws OXException {
        update.setFolderId(destFolder);
        update.setId(source.getId());
        this.saveFileMetadata(update, sequenceNumber, modifiedFields);
        return new FileStorageFileAccess.IDTuple(update.getFolderId(), update.getId());
    }

    public List<File.Field> getSupportedFields() {
        return Arrays.asList(File.Field.values());
    }

    private String getTrashFolderID() throws OXException {
        block3: {
            FileStorageFolderAccess folderAccess = this.getAccountAccess().getFolderAccess();
            try {
                FileStorageFolder trashFolder = folderAccess.getTrashFolder();
                if (null != trashFolder) {
                    return trashFolder.getId();
                }
            }
            catch (OXException e) {
                if (FileStorageExceptionCodes.NO_SUCH_FOLDER.equals(e)) break block3;
                throw e;
            }
        }
        return null;
    }
}

