/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileHolder;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.FileStorageVersionedFileAccess;
import com.openexchange.file.storage.VersionContainer;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.DeltaImpl;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class InMemoryFileStorageFileAccess
implements FileStorageFileAccess,
FileStorageVersionedFileAccess {
    private final Map<String, Map<String, VersionContainer>> storage = new HashMap<String, Map<String, VersionContainer>>();
    private final String accountId;
    private final String serviceId;

    public InMemoryFileStorageFileAccess(String serviceId, String accountId) {
        this.serviceId = serviceId;
        this.accountId = accountId;
    }

    public boolean exists(String folderId, String id, String version) throws OXException {
        Map<String, VersionContainer> map = this.storage.get(folderId);
        if (map == null) {
            return false;
        }
        return map.containsKey(id) ? map.get(id).containsVersion(Integer.parseInt(version)) : false;
    }

    public File getFileMetadata(String folderId, String id, String version) throws OXException {
        VersionContainer versionContainer = this.getVersionContainer(folderId, id);
        if (version == FileStorageFileAccess.CURRENT_VERSION) {
            version = Integer.toString(versionContainer.getCurrentVersionNumber());
        }
        if (versionContainer.containsVersion(Integer.parseInt(version))) {
            return versionContainer.getVersion(Integer.parseInt(version)).getFile();
        }
        throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
    }

    private VersionContainer getVersionContainer(String folderId, String id) throws OXException {
        Map<String, VersionContainer> map = this.storage.get(folderId);
        if (map == null) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
        }
        VersionContainer versionContainer = map.get(id);
        if (versionContainer == null) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
        }
        return versionContainer;
    }

    public FileStorageFileAccess.IDTuple saveFileMetadata(File file, long sequenceNumber) throws OXException {
        return this.save(file, null);
    }

    public FileStorageFileAccess.IDTuple saveFileMetadata(File file, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        return this.save(file, null);
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber) throws OXException {
        return this.save(file, data);
    }

    public FileStorageFileAccess.IDTuple saveDocument(File file, InputStream data, long sequenceNumber, List<File.Field> modifiedFields) throws OXException {
        return this.save(file, data);
    }

    private FileStorageFileAccess.IDTuple save(File file, InputStream data) throws OXException {
        String id;
        String folderId = file.getFolderId();
        Map<String, VersionContainer> map = this.storage.get(folderId);
        if (map == null) {
            map = new HashMap<String, VersionContainer>();
            this.storage.put(folderId, map);
        }
        if ((id = file.getId()) == FileStorageFileAccess.NEW) {
            id = UUID.randomUUID().toString();
            file.setId(id);
            FileHolder holder = data == null ? new FileHolder(file) : new FileHolder(file, data);
            VersionContainer versionContainer = new VersionContainer();
            int version = versionContainer.addVersion(holder);
            file.setVersion(Integer.toString(version));
            map.put(id, versionContainer);
            return new FileStorageFileAccess.IDTuple(folderId, id);
        }
        VersionContainer versionContainer = map.get(id);
        if (versionContainer == null) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
        }
        FileHolder holder = data == null ? new FileHolder(file) : new FileHolder(file, data);
        int version = versionContainer.addVersion(holder);
        file.setVersion(Integer.toString(version));
        String oldId = id;
        id = UUID.randomUUID().toString();
        file.setId(id);
        map.put(id, map.remove(oldId));
        for (FileHolder fh : versionContainer.getAllVersions()) {
            fh.getInternalFile().setId(id);
        }
        return new FileStorageFileAccess.IDTuple(folderId, id);
    }

    public void removeDocument(String folderId, long sequenceNumber) throws OXException {
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber) throws OXException {
        return this.removeDocument(ids, sequenceNumber, false);
    }

    public List<FileStorageFileAccess.IDTuple> removeDocument(List<FileStorageFileAccess.IDTuple> ids, long sequenceNumber, boolean hardDelete) throws OXException {
        ArrayList<FileStorageFileAccess.IDTuple> notRemoved = new ArrayList<FileStorageFileAccess.IDTuple>();
        for (FileStorageFileAccess.IDTuple tuple : ids) {
            String folderId = tuple.getFolder();
            String id = tuple.getId();
            Map<String, VersionContainer> map = this.storage.get(folderId);
            if (map == null) {
                notRemoved.add(tuple);
                continue;
            }
            VersionContainer versionContainer = map.remove(id);
            if (versionContainer != null) continue;
            notRemoved.add(tuple);
        }
        return notRemoved;
    }

    public String[] removeVersion(String folderId, String id, String[] versions) throws OXException {
        ArrayList<String> notRemovedList = new ArrayList<String>();
        Map<String, VersionContainer> map = this.storage.get(folderId);
        if (map == null) {
            return versions;
        }
        VersionContainer versionContainer = map.get(id);
        if (versionContainer == null) {
            return versions;
        }
        for (String version : versions) {
            FileHolder holder = version == FileStorageFileAccess.CURRENT_VERSION ? versionContainer.removeVersion(versionContainer.getCurrentVersionNumber()) : versionContainer.removeVersion(Integer.parseInt(version));
            if (holder != null) continue;
            notRemovedList.add(version);
        }
        String[] notRemoved = new String[notRemovedList.size()];
        for (int i = 0; i < notRemoved.length; ++i) {
            notRemoved[i] = (String)notRemovedList.get(i);
        }
        return notRemoved;
    }

    public InputStream getDocument(String folderId, String id, String version) throws OXException {
        VersionContainer versionContainer = this.getVersionContainer(folderId, id);
        FileHolder holder = version == FileStorageFileAccess.CURRENT_VERSION ? versionContainer.getCurrentVersion() : versionContainer.getVersion(Integer.parseInt(version));
        if (holder == null) {
            throw FileStorageExceptionCodes.FILE_NOT_FOUND.create(new Object[]{id, folderId});
        }
        return holder.getContent();
    }

    public FileStorageFileAccess.IDTuple copy(FileStorageFileAccess.IDTuple source, String version, String destFolder, File update, InputStream newFile, List<File.Field> modifiedFields) throws OXException {
        File orig = this.getFileMetadata(source.getFolder(), source.getId(), version);
        if (newFile == null && orig.getFileName() != null) {
            newFile = this.getDocument(source.getFolder(), source.getId(), version);
        }
        if (update != null) {
            orig.copyFrom(update, modifiedFields.toArray(new File.Field[modifiedFields.size()]));
        }
        orig.setId(NEW);
        orig.setFolderId(destFolder);
        if (newFile == null) {
            this.saveFileMetadata(orig, -1L);
        } else {
            this.saveDocument(orig, newFile, -1L);
        }
        return new FileStorageFileAccess.IDTuple(destFolder, orig.getId());
    }

    public FileStorageFileAccess.IDTuple move(FileStorageFileAccess.IDTuple source, String destFolder, long sequenceNumber, File update, List<File.Field> modifiedFields) throws OXException {
        File orig = this.getFileMetadata(source.getFolder(), source.getId(), CURRENT_VERSION);
        if (update != null) {
            orig.copyFrom(update, modifiedFields.toArray(new File.Field[modifiedFields.size()]));
        }
        orig.setFolderId(destFolder);
        this.saveFileMetadata(orig, sequenceNumber, modifiedFields);
        return new FileStorageFileAccess.IDTuple(destFolder, orig.getId());
    }

    public void touch(String folderId, String id) throws OXException {
    }

    public TimedResult<File> getDocuments(String folderId) throws OXException {
        Map<String, VersionContainer> files = this.storage.get(folderId);
        return new InMemoryTimedResult(files);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields) throws OXException {
        return this.getDocuments(folderId);
    }

    public TimedResult<File> getDocuments(String folderId, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        return new InMemoryTimedResult(this.storage.get(folderId), sort, order);
    }

    public TimedResult<File> getVersions(String folderId, String id) throws OXException {
        VersionContainer versionContainer = this.getVersionContainer(folderId, id);
        return new AllVersionsTimedResult(versionContainer);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields) throws OXException {
        VersionContainer versionContainer = this.getVersionContainer(folderId, id);
        return new AllVersionsTimedResult(versionContainer);
    }

    public TimedResult<File> getVersions(String folderId, String id, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order) throws OXException {
        VersionContainer versionContainer = this.getVersionContainer(folderId, id);
        return new AllVersionsTimedResult(versionContainer, sort, order);
    }

    public TimedResult<File> getDocuments(final List<FileStorageFileAccess.IDTuple> ids, List<File.Field> fields) throws OXException {
        return new TimedResult<File>(){

            public SearchIterator<File> results() throws OXException {
                ArrayList<File> files = new ArrayList<File>(ids.size());
                for (FileStorageFileAccess.IDTuple idTuple : ids) {
                    files.add(InMemoryFileStorageFileAccess.this.getVersionContainer(idTuple.getFolder(), idTuple.getId()).getCurrentVersion().getFile());
                }
                return new SearchIteratorAdapter(files.iterator(), files.size());
            }

            public long sequenceNumber() throws OXException {
                return System.currentTimeMillis();
            }
        };
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, boolean ignoreDeleted) throws OXException {
        return new DeltaImpl(this.getDocuments(folderId).results(), SearchIteratorAdapter.emptyIterator(), SearchIteratorAdapter.emptyIterator(), System.currentTimeMillis());
    }

    public Delta<File> getDelta(String folderId, long updateSince, List<File.Field> fields, File.Field sort, FileStorageFileAccess.SortDirection order, boolean ignoreDeleted) throws OXException {
        return new DeltaImpl(this.getDocuments(folderId, fields, sort, order).results(), SearchIteratorAdapter.emptyIterator(), SearchIteratorAdapter.emptyIterator(), System.currentTimeMillis());
    }

    public SearchIterator<File> search(String pattern, List<File.Field> fields, String folderId, File.Field sort, FileStorageFileAccess.SortDirection order, int start, int end) throws OXException {
        return SearchIteratorAdapter.emptyIterator();
    }

    public FileStorageAccountAccess getAccountAccess() {
        return new FileStorageAccountAccess(){

            public boolean ping() throws OXException {
                return true;
            }

            public boolean isConnected() {
                return true;
            }

            public void connect() throws OXException {
            }

            public void close() {
            }

            public boolean cacheable() {
                return true;
            }

            public FileStorageService getService() {
                return new FileStorageService(){

                    public Set<String> getSecretProperties() {
                        return null;
                    }

                    public String getId() {
                        return InMemoryFileStorageFileAccess.this.serviceId;
                    }

                    public DynamicFormDescription getFormDescription() {
                        return null;
                    }

                    public String getDisplayName() {
                        return null;
                    }

                    public FileStorageAccountManager getAccountManager() throws OXException {
                        return null;
                    }

                    public FileStorageAccountAccess getAccountAccess(String accountId, Session session) throws OXException {
                        return null;
                    }
                };
            }

            public FileStorageFolder getRootFolder() throws OXException {
                return null;
            }

            public FileStorageFolderAccess getFolderAccess() throws OXException {
                return null;
            }

            public FileStorageFileAccess getFileAccess() throws OXException {
                return null;
            }

            public String getAccountId() {
                return InMemoryFileStorageFileAccess.this.accountId;
            }
        };
    }

    public void startTransaction() throws OXException {
    }

    public void commit() throws OXException {
    }

    public void rollback() throws OXException {
    }

    public void finish() throws OXException {
    }

    public void setTransactional(boolean transactional) {
    }

    public void setRequestTransactional(boolean transactional) {
    }

    public void setCommitsTransaction(boolean commits) {
    }

    public class AllVersionsTimedResult
    implements TimedResult<File> {
        private final VersionContainer versionContainer;
        private File.Field sort;
        private FileStorageFileAccess.SortDirection order;
        private final long sequenceNumber = System.currentTimeMillis();

        public AllVersionsTimedResult(VersionContainer versionContainer) {
            this.versionContainer = versionContainer;
        }

        public AllVersionsTimedResult(VersionContainer versionContainer, File.Field sort, FileStorageFileAccess.SortDirection order) {
            this.versionContainer = versionContainer;
            this.sort = sort;
            this.order = order;
        }

        public SearchIterator<File> results() throws OXException {
            if (this.versionContainer == null) {
                return SearchIteratorAdapter.emptyIterator();
            }
            Collection<FileHolder> allVersions = this.versionContainer.getAllVersions();
            ArrayList<File> versions = new ArrayList<File>(allVersions.size());
            for (FileHolder fileHolder : allVersions) {
                versions.add(fileHolder.getFile());
            }
            if (this.sort != null && this.order != null) {
                Collections.sort(versions, this.order.comparatorBy(this.sort));
            }
            return new SearchIteratorAdapter(versions.iterator(), versions.size());
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }

    private final class InMemoryTimedResult
    implements TimedResult<File> {
        private final Map<String, VersionContainer> files;
        private final long sequenceNumber;
        private File.Field sort;
        private FileStorageFileAccess.SortDirection order;

        public InMemoryTimedResult(Map<String, VersionContainer> files) {
            this.files = files == null ? new HashMap() : files;
            this.sequenceNumber = System.currentTimeMillis();
        }

        public InMemoryTimedResult(Map<String, VersionContainer> files, File.Field sort, FileStorageFileAccess.SortDirection order) {
            this(files);
            this.sort = sort;
            this.order = order;
        }

        public SearchIterator<File> results() throws OXException {
            ArrayList<File> fileList = new ArrayList<File>(this.files.size());
            for (VersionContainer container : this.files.values()) {
                File file = container.getCurrentVersion().getFile();
                fileList.add(file);
            }
            if (this.sort != null && this.order != null) {
                Collections.sort(fileList, this.order.comparatorBy(this.sort));
            }
            return new SearchIteratorAdapter(fileList.iterator(), fileList.size());
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }
    }
}

