/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bug6056Test
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(Bug6056Test.class);

    public Bug6056Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug6065() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("Bug6065Test" + System.currentTimeMillis());
        folderObj.setParentFolderID(2);
        folderObj.setModule(2);
        folderObj.setType(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int newFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = this.createAppointmentObject("Bug6065Test");
        appointmentObj.setParentFolderID(newFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = Bug6056Test.insertAppointment(this.getWebConversation(), appointmentObj, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = Bug6056Test.loadAppointment(this.getWebConversation(), objectId, newFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date lastModified = loadAppointment.getLastModified();
        Bug6056Test.deleteAppointment(this.getWebConversation(), objectId, newFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        Appointment[] appointmentArray = AppointmentTest.listAppointment(this.getWebConversation(), newFolderId, lastModified, false, true, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            found = true;
        }
        Bug6056Test.assertTrue((String)"object not found in delete response", (boolean)found);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{newFolderId}, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

