/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.transformators.Transformator;

public class EMailFlagsTransformator
implements Transformator {
    @Override
    public Object transform(String value) throws OXException {
        String[] splitted;
        if (null == value || 1 > value.length()) {
            return 0;
        }
        int flags = 0;
        for (String flag : splitted = value.split(",")) {
            if (null == flag) continue;
            flags |= this.getFlag(flag.trim());
        }
        return flags;
    }

    private int getFlag(String flag) {
        if ("FLAG_ANSWERED".equalsIgnoreCase(flag) || "ANSWERED".equalsIgnoreCase(flag)) {
            return 1;
        }
        if ("FLAG_DELETED".equalsIgnoreCase(flag) || "DELETED".equalsIgnoreCase(flag)) {
            return 2;
        }
        if ("FLAG_DRAFT".equalsIgnoreCase(flag) || "DRAFT".equalsIgnoreCase(flag)) {
            return 4;
        }
        if ("FLAG_FLAGGED".equalsIgnoreCase(flag) || "FLAGGED".equalsIgnoreCase(flag)) {
            return 8;
        }
        if ("FLAG_RECENT".equalsIgnoreCase(flag) || "RECENT".equalsIgnoreCase(flag)) {
            return 16;
        }
        if ("FLAG_SEEN".equalsIgnoreCase(flag) || "SEEN".equalsIgnoreCase(flag)) {
            return 32;
        }
        if ("FLAG_USER".equalsIgnoreCase(flag) || "USER".equalsIgnoreCase(flag)) {
            return 64;
        }
        if ("FLAG_SPAM".equalsIgnoreCase(flag) || "SPAM".equalsIgnoreCase(flag)) {
            return 128;
        }
        if ("FLAG_FORWARDED".equalsIgnoreCase(flag) || "FORWARDED".equalsIgnoreCase(flag)) {
            return 256;
        }
        if ("FLAG_READ_ACK".equalsIgnoreCase(flag) || "READ_ACK".equalsIgnoreCase(flag)) {
            return 512;
        }
        return 0;
    }
}

