/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvyaml.YAML;

public class YAMLFixtureLoader
implements FixtureLoader {
    private final List<File> loadPath = new ArrayList<File>();
    private final Map<String, Map<String, Map<String, String>>> fixtureDefinitions = new HashMap<String, Map<String, Map<String, String>>>();
    private final Map<Class<?>, FixtureFactory<?>> factories = new HashMap();
    private final Map<String, Fixtures<?>> fixturesCache = new HashMap();
    private final Map<String, Class<?>> fixturesClasses = new HashMap();

    @Override
    public void appendToLoadPath(String ... paths) {
        for (String path : paths) {
            this.loadPath.add(new File(path));
        }
    }

    @Override
    public void load(String ... fixtureNames) throws OXException {
        for (String fixtureName : fixtureNames) {
            this.parse(this.locateFile(fixtureName), fixtureName);
        }
    }

    @Override
    public <T> Fixtures<T> getFixtures(String fixtureName, Class<T> aClass) throws OXException {
        if (this.fixturesCache.containsKey(fixtureName) && this.fixturesClasses.get(fixtureName).equals(aClass)) {
            return this.fixturesCache.get(fixtureName);
        }
        if (null == this.fixtureDefinitions.get(fixtureName)) {
            this.load(fixtureName);
        }
        Fixtures<T> fixtures = this.getFixtureFactory(aClass).createFixture(fixtureName, this.fixtureDefinitions.get(fixtureName));
        this.fixturesCache.put(fixtureName, fixtures);
        this.fixturesClasses.put(fixtureName, aClass);
        return fixtures;
    }

    public <T> void addFixtureFactory(FixtureFactory<T> factory, Class<T> c) {
        this.factories.put(c, factory);
    }

    private File locateFile(String fixtureName) throws OXException {
        for (File path : this.loadPath) {
            File fixtureFile = new File(path, fixtureName).getAbsoluteFile();
            if (fixtureFile.exists()) {
                return fixtureFile;
            }
            fixtureFile = new File(path, fixtureName + ".yml").getAbsoluteFile();
            if (!fixtureFile.exists()) continue;
            return fixtureFile;
        }
        StringBuilder sb = new StringBuilder();
        for (File path : this.loadPath) {
            sb.append('\"');
            sb.append(path.getAbsolutePath());
            sb.append('\"');
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        throw new FixtureException("Can't find fixture " + fixtureName + " in path: " + sb.toString());
    }

    private void parse(File file, String fixtureName) throws OXException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF8"));
            this.fixtureDefinitions.put(fixtureName, (Map)YAML.load((Reader)reader));
        }
        catch (FileNotFoundException e) {
            throw new FixtureException(e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private <T> FixtureFactory<T> getFixtureFactory(Class<T> aClass) throws OXException {
        if (!this.factories.containsKey(aClass)) {
            throw new FixtureException("Can't load fixtures of type: " + aClass);
        }
        return this.factories.get(aClass);
    }
}

