/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Document;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.InfoItem;
import com.openexchange.test.fixtures.transformators.DocumentsTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import com.openexchange.test.fixtures.transformators.UserIdTransformator;
import java.util.HashMap;
import java.util.Map;

public class InfoItemFixtureFactory
implements FixtureFactory<InfoItem> {
    private final FixtureLoader fixtureLoader;

    public InfoItemFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<InfoItem> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new InfoItemFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class InfoItemFixtures
    extends DefaultFixtures<InfoItem>
    implements Fixtures<InfoItem> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<InfoItem>> knownInfoitems;

        public InfoItemFixtures(String fixtureName, Map<String, Map<String, String>> values, FixtureLoader fixtureLoader) {
            super(InfoItem.class, values, fixtureLoader);
            this.knownInfoitems = new HashMap<String, Fixture<InfoItem>>();
            this.entries = values;
            super.addTransformator((Transformator)new DocumentsTransformator(fixtureLoader), "versions");
            super.addTransformator((Transformator)new UserIdTransformator(fixtureLoader), "created_by");
        }

        @Override
        public Fixture<InfoItem> getEntry(String entryName) throws OXException {
            if (this.knownInfoitems.containsKey(entryName)) {
                return this.knownInfoitems.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            InfoItem item = new InfoItem();
            this.apply(item, values);
            if (item.containsVersions()) {
                for (Document version : item.getVersions()) {
                    version.setParent(item);
                }
            }
            Fixture<InfoItem> fixture = new Fixture<InfoItem>(item, values.keySet().toArray(new String[values.size()]), values);
            this.knownInfoitems.put(entryName, fixture);
            return fixture;
        }
    }
}

