/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.GroupResolver;
import com.openexchange.test.fixtures.transformators.BooleanTransformator;
import com.openexchange.test.fixtures.transformators.JChronicLongTransformator;
import com.openexchange.test.fixtures.transformators.ParticipantTransformator;
import com.openexchange.test.fixtures.transformators.RecurrenceTypeTransformator;
import com.openexchange.test.fixtures.transformators.ShowAsTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AppointmentFixtureFactory
implements FixtureFactory<Appointment> {
    private final FixtureLoader fixtureLoader;
    private final GroupResolver groupResolver;

    public AppointmentFixtureFactory(GroupResolver groupResolver, FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
        this.groupResolver = groupResolver;
    }

    @Override
    public Fixtures<Appointment> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new AppointmentFixtures(fixtureName, entries, this.fixtureLoader, this.groupResolver);
    }

    private class AppointmentFixtures
    extends DefaultFixtures<Appointment>
    implements Fixtures<Appointment> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Appointment>> appointments;
        private final GroupResolver groupResolver;

        public AppointmentFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader, GroupResolver groupResolver) {
            super(Appointment.class, entries, fixtureLoader);
            this.appointments = new HashMap<String, Fixture<Appointment>>();
            this.entries = entries;
            this.groupResolver = groupResolver;
            this.addTransformator((Transformator)new ShowAsTransformator(), "shown_as");
            this.addTransformator((Transformator)new BooleanTransformator(), "full_time");
            this.addTransformator((Transformator)new ParticipantTransformator(fixtureLoader), "participants");
            this.addTransformator((Transformator)new BooleanTransformator(), "private_flag");
            this.addTransformator((Transformator)new JChronicLongTransformator(fixtureLoader), "recurring_start");
            this.addTransformator((Transformator)new RecurrenceTypeTransformator(), "recurrence_type");
        }

        @Override
        public Fixture<Appointment> getEntry(String entryName) throws OXException {
            if (this.appointments.containsKey(entryName)) {
                return this.appointments.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            Appointment appointment = new Appointment();
            this.apply(appointment, values);
            this.applyUsers(appointment, this.groupResolver);
            Fixture<Appointment> fixture = new Fixture<Appointment>(appointment, values.keySet().toArray(new String[values.size()]), values);
            this.appointments.put(entryName, fixture);
            return fixture;
        }

        private void applyUsers(Appointment appointment, GroupResolver groupResolver) {
            Participant[] participants;
            if (null != appointment && null != (participants = appointment.getParticipants())) {
                ArrayList<UserParticipant> users = new ArrayList<UserParticipant>();
                for (Participant participant : participants) {
                    GroupParticipant group;
                    Contact[] groupMembers;
                    if (1 == participant.getType()) {
                        users.add((UserParticipant)participant);
                        continue;
                    }
                    if (2 != participant.getType() || null == (groupMembers = groupResolver.resolveGroup((group = (GroupParticipant)participant).getIdentifier()))) continue;
                    for (Contact groupMember : groupMembers) {
                        UserParticipant userParticipant = new UserParticipant(groupMember.getObjectID());
                        userParticipant.setDisplayName(groupMember.getDisplayName());
                        userParticipant.setEmailAddress(groupMember.getEmail1());
                        users.add(userParticipant);
                    }
                }
                appointment.setUsers(users);
            }
        }
    }
}

