/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.DataObject;
import java.util.Date;
import java.util.Set;
import junit.framework.TestCase;

public class DataObjectTest
extends TestCase {
    public void testFindDifferingFields() {
        DataObject dataObject = this.getDataObject();
        DataObject otherDataObject = this.getDataObject();
        otherDataObject.setCreatedBy(-1);
        this.assertDifferences(dataObject, otherDataObject, 2);
        otherDataObject.setCreationDate(new Date());
        this.assertDifferences(dataObject, otherDataObject, 2, 4);
        otherDataObject.setLastModified(new Date());
        this.assertDifferences(dataObject, otherDataObject, 2, 4, 5);
        otherDataObject.setModifiedBy(-23);
        this.assertDifferences(dataObject, otherDataObject, 2, 4, 5, 3);
        otherDataObject.setObjectID(12);
        this.assertDifferences(dataObject, otherDataObject, 2, 4, 5, 3, 1);
    }

    public void testAttrAccessors() {
        DataObject object = new DataObject(){};
        DataObjectTest.assertFalse((boolean)object.contains(5));
        DataObjectTest.assertFalse((boolean)object.containsLastModified());
        object.setLastModified(new Date(42L));
        DataObjectTest.assertTrue((boolean)object.contains(5));
        DataObjectTest.assertTrue((boolean)object.containsLastModified());
        DataObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(5));
        object.set(5, (Object)new Date(23L));
        DataObjectTest.assertEquals((Object)new Date(23L), (Object)object.getLastModified());
        object.remove(5);
        DataObjectTest.assertFalse((boolean)object.contains(5));
        DataObjectTest.assertFalse((boolean)object.containsLastModified());
        DataObjectTest.assertFalse((boolean)object.contains(1));
        DataObjectTest.assertFalse((boolean)object.containsObjectID());
        object.setObjectID(-12);
        DataObjectTest.assertTrue((boolean)object.contains(1));
        DataObjectTest.assertTrue((boolean)object.containsObjectID());
        DataObjectTest.assertEquals((Object)-12, (Object)object.get(1));
        object.set(1, (Object)12);
        DataObjectTest.assertEquals((int)12, (int)object.getObjectID());
        object.remove(1);
        DataObjectTest.assertFalse((boolean)object.contains(1));
        DataObjectTest.assertFalse((boolean)object.containsObjectID());
        DataObjectTest.assertFalse((boolean)object.contains(3));
        DataObjectTest.assertFalse((boolean)object.containsModifiedBy());
        object.setModifiedBy(-12);
        DataObjectTest.assertTrue((boolean)object.contains(3));
        DataObjectTest.assertTrue((boolean)object.containsModifiedBy());
        DataObjectTest.assertEquals((Object)-12, (Object)object.get(3));
        object.set(3, (Object)12);
        DataObjectTest.assertEquals((int)12, (int)object.getModifiedBy());
        object.remove(3);
        DataObjectTest.assertFalse((boolean)object.contains(3));
        DataObjectTest.assertFalse((boolean)object.containsModifiedBy());
        DataObjectTest.assertFalse((boolean)object.contains(4));
        DataObjectTest.assertFalse((boolean)object.containsCreationDate());
        object.setCreationDate(new Date(42L));
        DataObjectTest.assertTrue((boolean)object.contains(4));
        DataObjectTest.assertTrue((boolean)object.containsCreationDate());
        DataObjectTest.assertEquals((Object)new Date(42L), (Object)object.get(4));
        object.set(4, (Object)new Date(23L));
        DataObjectTest.assertEquals((Object)new Date(23L), (Object)object.getCreationDate());
        object.remove(4);
        DataObjectTest.assertFalse((boolean)object.contains(4));
        DataObjectTest.assertFalse((boolean)object.containsCreationDate());
        DataObjectTest.assertFalse((boolean)object.contains(2));
        DataObjectTest.assertFalse((boolean)object.containsCreatedBy());
        object.setCreatedBy(-12);
        DataObjectTest.assertTrue((boolean)object.contains(2));
        DataObjectTest.assertTrue((boolean)object.containsCreatedBy());
        DataObjectTest.assertEquals((Object)-12, (Object)object.get(2));
        object.set(2, (Object)12);
        DataObjectTest.assertEquals((int)12, (int)object.getCreatedBy());
        object.remove(2);
        DataObjectTest.assertFalse((boolean)object.contains(2));
        DataObjectTest.assertFalse((boolean)object.containsCreatedBy());
    }

    public void assertDifferences(DataObject dataObject, DataObject otherDataObject, int ... fields) {
        Set differingFields = dataObject.findDifferingFields(otherDataObject);
        String diffString = differingFields.toString();
        for (int field : fields) {
            DataObjectTest.assertTrue((String)(diffString + " Didn't find: " + field), (boolean)differingFields.remove(field));
        }
        DataObjectTest.assertTrue((String)(diffString + " Have unexpected field: " + differingFields), (boolean)differingFields.isEmpty());
    }

    private DataObject getDataObject() {
        DataObject dataObject = new DataObject(){};
        this.fillDataObject(dataObject);
        return dataObject;
    }

    public void fillDataObject(DataObject dataObject) {
        dataObject.setCreatedBy(1);
        dataObject.setCreationDate(new Date(2L));
        dataObject.setLastModified(new Date(3L));
        dataObject.setModifiedBy(4);
        dataObject.setObjectID(5);
    }
}

