/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;

public class Bug28734Test
extends CalDAVTest {
    public Bug28734Test(String name) {
        super(name);
    }

    public void testTimeZoneHongKong() throws Exception {
        String uid = Bug28734Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(((Object)((Object)this)).getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("september on friday at 20:00", TimeZone.getTimeZone("Asia/Hong_Kong")));
        appointment.setEndDate(TimeTools.D("september on friday at 21:00", TimeZone.getTimeZone("Asia/Hong_Kong")));
        appointment.setTimezone("Asia/Hong_Kong");
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(uid, null);
        Bug28734Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug28734Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug28734Test.assertTrue((String)"DTSTART wrong", (boolean)iCalResource.getVEvent().getPropertyValue("DTSTART").endsWith("T200000"));
        Bug28734Test.assertTrue((String)"DTEND wrong", (boolean)iCalResource.getVEvent().getPropertyValue("DTEND").endsWith("T210000"));
    }
}

