/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.data.conversion.ical.AbstractICalParserTest;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.ldap.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ICalParserBugTests
extends AbstractICalParserTest {
    public void testMultipleCalendars() throws ConversionError {
        Date start1 = CommonAppointments.D("24/02/1981 10:00");
        Date end1 = CommonAppointments.D("24/02/1981 12:00");
        Date start2 = CommonAppointments.D("24/02/1981 10:00");
        Date end2 = CommonAppointments.D("24/02/1981 12:00");
        StringBuilder combiner = new StringBuilder();
        combiner.append(this.fixtures.veventWithUTCDTStartAndDTEnd(start1, end1)).append('\n').append(this.fixtures.veventWithUTCDTStartAndDTEnd(start2, end2));
        List appointments = this.parser.parseAppointments(combiner.toString(), TimeZone.getTimeZone("UTC"), null, new ArrayList(), new ArrayList());
        ICalParserBugTests.assertEquals((int)2, (int)appointments.size());
    }

    public void testAppShouldInterpretConfidentialAsPrivate() throws ConversionError {
        String icalText = this.fixtures.veventWithSimpleProperties(CommonAppointments.D("24/02/1981 10:00"), CommonAppointments.D("24/02/1981 12:00"), "CLASS", "CONFIDENTIAL");
        CalendarDataObject appointment = this.parseAppointment(icalText);
        ICalParserBugTests.assertTrue((String)"CLASS:CONFIDENTIAL should resolve to private appointments", (boolean)appointment.getPrivateFlag());
    }

    public void testTimezoneShouldBeRelevantForAllData() throws ConversionError {
        String timezone = "BEGIN:VTIMEZONE\nTZID:/mozilla.org/20050126_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\nEND:DAYLIGHT\nEND:VTIMEZONE\n";
        String icalText1 = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20050126_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\nEND:DAYLIGHT\nEND:VTIMEZONE\nBEGIN:VEVENT\nCREATED:20080216T152600Z\nLAST-MODIFIED:20080216T152600Z\nDTSTAMP:20080216T152600Z\nUID:3a289f91-f83a-4614-83c6-660c7740abd8\nSUMMARY:New York, 2008-08-31 09:00 - 10:00 (EST)\nDTSTART;TZID=/mozilla.org/20050126_1/America/New_York:20080831T090000\nDTEND;TZID=/mozilla.org/20050126_1/America/New_York:20080831T100000\nEND:VEVENT\nEND:VCALENDAR\n";
        String icalText2 = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\nBEGIN:VEVENT\nCREATED:20080216T152600Z\nLAST-MODIFIED:20080216T152600Z\nDTSTAMP:20080216T152600Z\nUID:3a289f91-f83a-4614-83c6-660c7740abd8\nSUMMARY:New York, 2008-08-31 09:00 - 10:00 (EST)\nDTSTART;TZID=/mozilla.org/20050126_1/America/New_York:20080831T090000\nDTEND;TZID=/mozilla.org/20050126_1/America/New_York:20080831T100000\nEND:VEVENT\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20050126_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n";
        CalendarDataObject appointmentThatTroublesUs = this.parseAppointment("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20050126_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\nEND:DAYLIGHT\nEND:VTIMEZONE\nBEGIN:VEVENT\nCREATED:20080216T152600Z\nLAST-MODIFIED:20080216T152600Z\nDTSTAMP:20080216T152600Z\nUID:3a289f91-f83a-4614-83c6-660c7740abd8\nSUMMARY:New York, 2008-08-31 09:00 - 10:00 (EST)\nDTSTART;TZID=/mozilla.org/20050126_1/America/New_York:20080831T090000\nDTEND;TZID=/mozilla.org/20050126_1/America/New_York:20080831T100000\nEND:VEVENT\nEND:VCALENDAR\n");
        CalendarDataObject appointmentAsExpected = this.parseAppointment("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Mozilla.org/NONSGML Mozilla Calendar V1.1//EN\nBEGIN:VEVENT\nCREATED:20080216T152600Z\nLAST-MODIFIED:20080216T152600Z\nDTSTAMP:20080216T152600Z\nUID:3a289f91-f83a-4614-83c6-660c7740abd8\nSUMMARY:New York, 2008-08-31 09:00 - 10:00 (EST)\nDTSTART;TZID=/mozilla.org/20050126_1/America/New_York:20080831T090000\nDTEND;TZID=/mozilla.org/20050126_1/America/New_York:20080831T100000\nEND:VEVENT\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20050126_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=4\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n");
        ICalParserBugTests.assertEquals((String)"Start dates should be equal, independent of the placement of the timezone information", (Object)appointmentAsExpected.getStartDate(), (Object)appointmentThatTroublesUs.getStartDate());
        ICalParserBugTests.assertEquals((String)"End dates should be equal, independent of the placement of the timezone information", (Object)appointmentAsExpected.getEndDate(), (Object)appointmentThatTroublesUs.getEndDate());
    }

    public void testShouldHandleMultipleLineArguments() throws ConversionError {
        String foldedSummary = "This is a so called 'folded' argument\n meaning it is split\n into multiple lines\n each starting with a whitespace character";
        String unfoldedSummary = "This is a so called 'folded' argument\n meaning it is split\n into multiple lines\n each starting with a whitespace character".replace("\n ", "");
        String icalText = this.fixtures.veventWithSimpleProperties(new Date(), new Date(), "SUMMARY", "This is a so called 'folded' argument\n meaning it is split\n into multiple lines\n each starting with a whitespace character");
        CalendarDataObject appointment = this.parseAppointment(icalText);
        ICalParserBugTests.assertEquals((String)"Unfolded summary does not match transformed title", (String)unfoldedSummary, (String)appointment.getTitle());
    }

    public void testBug16110() throws Exception {
        String ical = "BEGIN:VCALENDAR\nMETHOD:REQUEST\nPRODID:Microsoft CDO for Microsoft Exchange\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:(GMT+09.00) Tokyo/Osaka/Sapporo\nX-MICROSOFT-CDO-TZID:20\nBEGIN:STANDARD\nDTSTART:16010101T000000\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nEND:STANDARD\nBEGIN:DAYLIGHT\nDTSTART:16010101T000000\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nEND:DAYLIGHT\nEND:VTIMEZONE\nBEGIN:VEVENT\nDTSTAMP:20100514T031141Z\nDTSTART;TZID=\"(GMT+09.00) Tokyo/Osaka/Sapporo\":20100514T143000\nSUMMARY:Updated: OX status Meeting\nUID:040000008200E00074C5B7101A82E0080000000020EEAA4753F3CA01000000000000000\n 0100000009A5B902A6C1C7E43AF1988197DCE07C2\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Ramesh G\n opal\":MAILTO:Ramesh.Gopal@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Imai Tom\n oko\":MAILTO:Tomoko.Imai@shinseibank.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"PengSeng\n  Fong\":MAILTO:PengSeng.Fong@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Okuyama \n Makoto\":MAILTO:Makoto.Okuyama@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Nakamura\n  Nanako\":MAILTO:Nanako.Nakamura@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;X-REPLYTIME=20100514T02\n 5600Z;RSVP=FALSE;CN=\"Suresh Bollu\":MAILTO:Suresh.Bollu@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Zhuang, \n Xiaoye\":MAILTO:xiaoye.zhuang@somefinancial.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Anand Ku\n mbhare\":MAILTO:Anand.Kumbhare@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Praveen \n Kumar\":MAILTO:Praveen.Kumar@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Amogh Ku\n lkarni\":MAILTO:Amogh.Kulkarni@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Carsten \n Hoeger\":MAILTO:choeger@open-xchange.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Mathews \n Jacob\":MAILTO:Mathews.Jacob@some-it.invalid\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Holger A\n chtziger\":MAILTO:Holger.Achtziger@open-xchange.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;X-REPLYTIME=20100514T02\n 5400Z;RSVP=FALSE;CN=\"Ido Nansyuu\":MAILTO:Nansyuu.Ido@some-it.invalid\nATTENDEE;ROLE=OPT-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Pieter F\n ranken\":MAILTO:Pieter.Franken@somebank.com\nATTENDEE;ROLE=OPT-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Yamazaki\n  Chika\":MAILTO:Chika.Yamazaki@some-it.invalid\nATTENDEE;ROLE=OPT-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=FALSE;CN=\"Wenlong \n Wu\":MAILTO:Wenlong.Wu@some-it.invalid\nORGANIZER;CN=\"ChinShimVeron Koh\":MAILTO:ChinShimVeron.Koh@some-it.invalid\nLOCATION:\nDTEND;TZID=\"(GMT+09.00) Tokyo/Osaka/Sapporo\":20100514T153000\nDESCRIPTION:Please note that the meeting is today 14 May.\\N\\NDear all\\,\\N\\N\n We are targeting to migrate 300 users to Open Xchange in Production on Mon\n day. Please attend the meeting for activity and status updates.\\N\\NPune te\n am\\, please help to connect VC.\\NCan someone help to book the meeting room\n s in Japan as I am unable to book any from my side.\\N\\N\\N[Date and Venue]\\n N14 May 2010 2:30-3:30 JST   @Meeting Room 2/Singapore\\N\\N[Agenda]\\N1) Perfo\n rmance issue fix status\\N2) H/W availability\\N3) Monitoring & Security\\N4)\n  Migration plan including communication plan\\N5) Weekend Support/Personnel\n  required\\N\\NThanks & Regards\\,\\NVeron Koh\\N \\NProject Management Unit (PM\n U)\\NPhone: +65 6403 5049 (External)\\NPhone: 35049 (Internal)\\NEmail:  Chin\n ShimVeron.Koh@some-it.invalid\\N\nSEQUENCE:0\nPRIORITY:5\nCLASS:\nCREATED:20100514T031142Z\nLAST-MODIFIED:20100514T031143Z\nSTATUS:CONFIRMED\nTRANSP:OPAQUE\nX-MICROSOFT-CDO-BUSYSTATUS:BUSY\nX-MICROSOFT-CDO-INSTTYPE:0\nX-MICROSOFT-CDO-INTENDEDSTATUS:BUSY\nX-MICROSOFT-CDO-ALLDAYEVENT:FALSE\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-CDO-OWNERAPPTID:1968068570\nX-MICROSOFT-CDO-APPT-SEQUENCE:1\nX-MICROSOFT-CDO-ATTENDEE-CRITICAL-CHANGE:20100514T031141Z\nX-MICROSOFT-CDO-OWNER-CRITICAL-CHANGE:20100514T031141Z\nBEGIN:VALARM\nACTION:DISPLAY\nDESCRIPTION:REMINDER\nTRIGGER;RELATED=START:-PT00H15M00S\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n";
        CalendarDataObject appointment = this.parseAppointment(ical);
        ICalParserBugTests.assertEquals((String)"All participants should be external", (int)17, (int)appointment.getParticipants().length);
        ICalParserBugTests.assertEquals((String)"Organizer should match", (String)"ChinShimVeron.Koh@some-it.invalid", (String)appointment.getOrganizer());
        boolean choegerFound = false;
        boolean holgerFound = false;
        for (Participant p : appointment.getParticipants()) {
            if (p.getEmailAddress().equals("choeger@open-xchange.com")) {
                choegerFound = true;
            }
            if (!p.getEmailAddress().equals("holger.achtziger@open-xchange.com")) continue;
            holgerFound = true;
        }
        ICalParserBugTests.assertTrue((String)"Should contain CHoeger", (boolean)choegerFound);
        ICalParserBugTests.assertTrue((String)"Should contain Holger", (boolean)holgerFound);
    }

    public void testBug16237() throws Exception {
        String ical = "BEGIN:VCALENDAR\nMETHOD:REQUEST\nPRODID:Microsoft Exchange Server 2007\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:W. Europe Standard Time\nBEGIN:STANDARD\nDTSTART:16010101T030000\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10\nEND:STANDARD\nBEGIN:DAYLIGHT\nDTSTART:16010101T020000\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3\nEND:DAYLIGHT\nEND:VTIMEZONE\nBEGIN:VEVENT\nORGANIZER;CN=:MAILTO:Marco.Duetsch@swisscom.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=:MAILTO:ma\n rtin@ezuce.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=:MAILTO:je\n rry@ezuce.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=:MAILTO:fr\n ank.hoberg@open-xchange.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=:MAILTO:st\n ephan.martin@open-xchange.com\nATTENDEE;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;RSVP=TRUE;CN=:MAILTO:An\n dreas.Schmid1@swisscom.com\nDESCRIPTION;LANGUAGE=de-DE:Dial-in Number:   +41 52 267 07 22\\nParticipant \n Pin-Code: 224745\\n\\nDial-in Number:\\n 0800 329 329  Switzerland\\n 0800 181\n  93 93  Germany\\n 1 866 591 43 61  USA\\n 1 866 927 08 47 Canada\\n\\nHello a\n ll\\,\\nas discussed within our last call\\, I send you the invite for the re\n view meeting.\\n\\nGoal of the meeting: review of the document \u201cProposal f\n or Swisscom\u201d\\n\\nCheers Marco\\n\\n\\n\\n\nSUMMARY;LANGUAGE=de-DE:Review \"Proposal for Swisscom\"\nDTSTART;TZID=W. Europe Standard Time:20100625T160000\nDTEND;TZID=W. Europe Standard Time:20100625T170000\nUID:040000008200E00074C5B7101A82E00800000000C0B499355111CB01000000000000000\n 010000000ADC7372333BA844A9150A8B9981434F4\nCLASS:PUBLIC\nPRIORITY:5\nDTSTAMP:20100621T125119Z\nTRANSP:OPAQUE\nSTATUS:CONFIRMED\nSEQUENCE:0\nLOCATION;LANGUAGE=de-DE:conf-call\\, +41 52 267 07 22\\, pin-code: 224745 \nX-MICROSOFT-CDO-APPT-SEQUENCE:0\nX-MICROSOFT-CDO-OWNERAPPTID:1265985498\nX-MICROSOFT-CDO-BUSYSTATUS:TENTATIVE\nX-MICROSOFT-CDO-INTENDEDSTATUS:BUSY\nX-MICROSOFT-CDO-ALLDAYEVENT:FALSE\nX-MICROSOFT-CDO-IMPORTANCE:1\nX-MICROSOFT-CDO-INSTTYPE:0\nBEGIN:VALARM\nACTION:DISPLAY\nDESCRIPTION:REMINDER\nTRIGGER;RELATED=START:-PT15M\nEND:VALARM\nEND:VEVENT\nEND:VCALENDAR\n";
        this.parseAppointment(ical);
    }

    public void testBug16613() throws Exception {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Novell Inc//Groupwise 8.0.2 \nMETHOD:REQUEST\nBEGIN:VTIMEZONE\nTZID:(GMT-0500) Eastern Standard Time\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nDTSTART:20001107T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=1SU;BYMONTH=11\nTZNAME:Eastern Standard Time\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nDTSTART:20000314T020000\nRRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=2SU;BYMONTH=3\nTZNAME:Eastern Daylight Time\nEND:DAYLIGHT\nEND:VTIMEZONE\nBEGIN:VEVENT\nSUMMARY:Videoconference between Open X-change and Novell\nDTSTART;TZID=\"(GMT-0500) Eastern Standard Time\":20100824T083000\nTRANSP:OPAQUE\nX-GWSHOW-AS:BUSY\nSTATUS:CONFIRMED\nX-GWITEM-TYPE:APPOINTMENT\nDTSTAMP:20100728T164959Z\nORGANIZER;CN=\"Ron Hovsepian\";ROLE=CHAIR:MAILTO:123@ox.io\nATTENDEE;CN=\"WAL-VC-Old North Church-C52552\";PARTSTAT=NEEDS-ACTION;\n RSVP=TRUE;ROLE=REQ-PARTICIPANT;CUTYPE=RESOURCE:\n MAILTO:2323@ox.io\nATTENDEE;CN=\"PRV-VC-Arches\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT;CUTYPE=RESOURCE:\n MAILTO:444@ox.io\nATTENDEE;CN=\"Colleen O'Keefe\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT:MAILTO:ff@ox.io\nATTENDEE;CN=\"Ken Muir\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT:MAILTO:fff@ox.io\nATTENDEE;CN=\"Ron Hovsepian\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT:MAILTO:123@ox.io\nATTENDEE;CN=\"Richard Seibt\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT:\n MAILTO:richard.seibt@open-source-business-foundation.org\nATTENDEE;CN=\"Rafael Laguna de la Vera\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=REQ-PARTICIPANT:MAILTO:Rafael.Laguna@open-xchange.com\nATTENDEE;CN=\"Aditya Joshi\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:1234@ox.io\nATTENDEE;CN=\"Melanie Reichel\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:333@ox.io\nATTENDEE;CN=\"Jenalyn Cox\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:fdfdfd@ox.io\nATTENDEE;CN=\"Keith Bengtson\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:eeqq@ox.io\nATTENDEE;CN=\"Dianne Saunders\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:vvv@ox.io\nATTENDEE;CN=\"Marie Roche\";PARTSTAT=NEEDS-ACTION;RSVP=TRUE;\n ROLE=OPT-PARTICIPANT:MAILTO:3443@ox.io\nDESCRIPTION:\n 7/28/10:  resending appointment to cancel the use of the Nuremberg conferen\n ce room.\\n \\nRafael Laguna and Richard Seibt will attend the meeting in ou\n r Waltham office.\\n \\n \\n \\n\nATTACH;ENCODING=BASE64;VALUE=BINARY;ID=TEXT.htm:\n PEhUTUw+PEhFQUQ+DQo8TUVUQSBjb250ZW50PSJ0ZXh0L2h0bWw7IGNoYXJzZXQ9d2luZG93cy0\n xMjUyIiBodHRwLWVxdWl2PUNvbnRlbnQtVHlwZT4NCjxNRVRBIG5hbWU9R0VORVJBVE9SIGNvb\n nRlbnQ9Ik1TSFRNTCA4LjAwLjYwMDEuMTg5MjgiPjwvSEVBRD4NCjxCT0RZIHN0eWxlPSJNQVJ\n HSU46IDRweCA0cHggMXB4OyBGT05UOiAxMHB0IFRhaG9tYSI+DQo8RElWPjcvMjgvMTA6Jm5ic\n 3A7IHJlc2VuZGluZyBhcHBvaW50bWVudCB0byBjYW5jZWwgdGhlIHVzZSBvZiB0aGUgTnVyZW1\n iZXJnIGNvbmZlcmVuY2Ugcm9vbS48L0RJVj4NCjxESVY+Jm5ic3A7PC9ESVY+DQo8RElWPlJhZ\n mFlbCBMYWd1bmEgYW5kIFJpY2hhcmQgU2VpYnQgd2lsbCBhdHRlbmQgdGhlIG1lZXRpbmcgaW4\n gb3VyIFdhbHRoYW0gb2ZmaWNlLjwvRElWPg0KPERJVj4mbmJzcDs8L0RJVj4NCjxESVY+Jm5ic\n 3A7PC9ESVY+DQo8RElWPiZuYnNwOzwvRElWPjwvQk9EWT48L0hUTUw+\nDTEND;TZID=\"(GMT-0500) Eastern Standard Time\":20100824T100000\nLOCATION:WAL-VC-Old North Church-C52552 / PRV-VC-Arches\nUID:20100728T164959Z_D26000DF178\nPRIORITY:5\nCLASS:PUBLIC\nX-GWCLASS:NORMAL\nEND:VEVENT\nEND:VCALENDAR\n";
        this.parseAppointment(ical);
        ICalParserBugTests.assertTrue((String)"Should not fail ith parsing error before this", (boolean)true);
    }

    public void testDoesNotLikeEmailElementFromZimbra() throws Exception {
        String ical = "BEGIN:VCALENDAR\nPRODID:Zimbra-Calendar-Provider\nVERSION:2.0\nCALSCALE:GREGORIAN\nVERSION:2.0\nMETHOD:REQUEST\nPRODID:-//Apple Inc.//iCal 4.0.3//EN\nBEGIN:VTIMEZONE\nTZID:Europe/Paris\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nDTSTART:19810329T020000\nTZNAME:GMT+02:00\nTZOFFSETTO:+0200\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nDTSTART:19961027T030000\nTZNAME:GMT+01:00\nTZOFFSETTO:+0100\nEND:STANDARD\nEND:VTIMEZONE\nBEGIN:VEVENT\nCREATED:20100916T122236Z\nUID:32B3BF02-6736-4AF9-A6B0-68E290E7EFED\nDTEND;TZID=\"Europe/Paris\":20100917T203000\nATTENDEE;CN=Frank Hoberg;CUTYPE=INDIVIDUAL;EMAIL=frank.hoberg@open-xchange.c\n om;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailto:frank.hoberg@\n open-xchange.com\nATTENDEE;CN=Douglas Randall (Randy) Parker;CUTYPE=INDIVIDUAL;EMAIL=randall.p\n arker@scality.com;PARTSTAT=NEEDS-ACTION;ROLE=REQ-PARTICIPANT;RSVP=TRUE:mailt\n o:randall.parker@scality.com\nATTENDEE;CN=Marc Villemade;CUTYPE=INDIVIDUAL;PARTSTAT=ACCEPTED:mailto:m@scal\n ity.com\nTRANSP:OPAQUE\nSUMMARY:Sync up with Frank@OX about meeting in DC\nDTSTART;TZID=\"Europe/Paris\":20100917T193000\nDTSTAMP:20100916T161511Z\nORGANIZER;CN=Marc Villemade:mailto:m@scality.com\nSEQUENCE:15\nEND:VEVENT\nEND:VCALENDAR";
        this.parseAppointment(ical);
        ICalParserBugTests.assertTrue((String)"Should not fail with parsing error before this", (boolean)true);
    }

    public void testShouldNotGetConfusedByDifferentlyCapitalizedAddresses() throws Exception {
        User user = this.users.getUser(1);
        String[] parts = user.getMail().split("@");
        String localPart = parts[0];
        String capitalizedLocalPart = localPart.toUpperCase();
        String differentMail = capitalizedLocalPart + "@" + parts[1];
        ICalParserBugTests.assertFalse((String)"Precondition: New address should not match old address", (boolean)differentMail.equals(user.getMail()));
        ICalParserBugTests.assertTrue((String)"Precondition: New address should match old address if ignoring capitalization", (boolean)differentMail.equalsIgnoreCase(user.getMail()));
        String ical = "BEGIN:VCALENDAR\nPRODID:Open-Xchange\nVERSION:2.0\nCALSCALE:GREGORIAN\nMETHOD:REQUEST\nBEGIN:VEVENT\nDTSTAMP:20101116T074248Z\nSUMMARY:Launch-Strategie\nDESCRIPTION:ACHTUNG!\nDTSTART:20101116T100000Z\nDTEND:20101116T110000Z\nCLASS:PUBLIC\nLOCATION:TelCo Europe\nTRANSP:OPAQUE\nUID:1a756b4b-b685-48f8-a5ea-8146dd1805c7\nCREATED:20101116T074246Z\nLAST-MODIFIED:20101116T074246Z\nATTENDEE;ROLE=REQ-PARTICIPANT;CUTYPE=INDIVIDUAL:mailto:" + differentMail + "\n" + "END:VEVENT\n" + "END:VCALENDAR\n";
        CalendarDataObject appointment = this.parseAppointment(ical);
        Participant[] participants = appointment.getParticipants();
        ICalParserBugTests.assertEquals((String)"Should find one participant", (int)1, (int)participants.length);
        Participant participant = participants[0];
        ICalParserBugTests.assertEquals((String)"Should find a user, not an external participant", (int)1, (int)participant.getType());
    }
}

