/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Bug16006Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task;
    private TimeZone origTimeZone;
    private Date alarm;

    public Bug16006Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.origTimeZone = this.client.getValues().getTimeZone();
        this.client.execute(new SetRequest(Tree.TimeZone, "Pacific/Honolulu"));
        this.task = new Task();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 16006");
        Calendar calendar = TimeTools.createCalendar(TimeZones.UTC);
        this.alarm = calendar.getTime();
        this.task.setAlarm(calendar.getTime());
        InsertRequest request = new InsertRequest(this.task, TimeZones.UTC, true, true);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        this.client.execute(new SetRequest(Tree.TimeZone, this.origTimeZone.getID()));
        super.tearDown();
    }

    public void testAlarm() throws Throwable {
        GetRequest[] requests = new GetRequest[]{new GetRequest(this.task, TimeZones.UTC)};
        GetResponse response = (GetResponse)((Object)((MultipleResponse)this.client.execute(MultipleRequest.create(requests))).getResponse(0));
        Task testTask = response.getTask(TimeZones.UTC);
        Bug16006Test.assertEquals((String)"Alarm does not match.", (Object)this.alarm, (Object)testTask.getAlarm());
    }
}

