/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.session.actions.HttpAuthParser;
import com.openexchange.ajax.session.actions.HttpAuthRequest;
import com.openexchange.ajax.session.actions.HttpAuthResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;

public class EmptyHttpAuthRequest
extends HttpAuthRequest {
    final boolean locationNeeded;

    public EmptyHttpAuthRequest() {
        this(true);
    }

    public EmptyHttpAuthRequest(boolean locationNeeded) {
        super(null, null);
        this.locationNeeded = locationNeeded;
    }

    @Override
    public com.openexchange.ajax.framework.Header[] getHeaders() {
        return new com.openexchange.ajax.framework.Header[0];
    }

    @Override
    public HttpAuthParser getParser() {
        return new HttpAuthParser(){

            @Override
            public String checkResponse(HttpResponse resp) throws ParseException, IOException {
                this.setStatusCode(resp.getStatusLine().getStatusCode());
                this.setReasonPhrase(resp.getStatusLine().getReasonPhrase());
                if (EmptyHttpAuthRequest.this.locationNeeded) {
                    this.parseLocationHeader(resp);
                } else {
                    Header[] headers = resp.getHeaders("Location");
                    if (headers.length > 0) {
                        this.setLocation(headers[0].getValue());
                    }
                }
                if (302 == this.getStatusCode()) {
                    return EntityUtils.toString((HttpEntity)resp.getEntity());
                }
                return null;
            }

            @Override
            public HttpAuthResponse parse(String body) throws JSONException {
                if (EmptyHttpAuthRequest.this.locationNeeded) {
                    return (HttpAuthResponse)((Object)super.parse(body));
                }
                return this.createResponse(this.getLocation());
            }
        };
    }
}

