/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.SearchRequest;
import com.openexchange.ajax.mail.actions.SearchResponse;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.MailSortField;
import java.util.Date;
import javax.mail.internet.MailDateFormat;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(SearchTest.class);
    String mailObject_25kb;

    public SearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testSimpleSearch() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        JSONArray searchExpression = new JSONArray("['=', {'field':'from'}, '" + this.getSendAddress() + "']");
        JSONObject searchObject = new JSONObject().put("filter", (Object)searchExpression);
        SearchResponse searchR = Executor.execute(this.getSession(), new SearchRequest(searchObject, this.getInboxFolder(), COLUMNS_DEFAULT_LIST, MailSortField.RECEIVED_DATE.getField(), Order.DESCENDING, true));
        if (searchR.hasError()) {
            SearchTest.fail((String)searchR.getException().toString());
        }
        JSONArray array = (JSONArray)searchR.getData();
        SearchTest.assertEquals((String)"Unexpected number of search results.", (int)25, (int)array.length());
    }

    public void testComplexSearch() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        JSONArray searchExpression1 = new JSONArray("['=', {'field':'from'}, '" + this.getSendAddress() + "']");
        JSONArray searchExpression2 = new JSONArray("['>', {'field':'size'}, '1']");
        JSONArray searchExpression = new JSONArray("['or', " + searchExpression1 + "," + searchExpression2 + "]");
        JSONObject searchObject = new JSONObject().put("filter", (Object)searchExpression);
        SearchResponse searchR = Executor.execute(this.getSession(), new SearchRequest(searchObject, this.getInboxFolder(), COLUMNS_DEFAULT_LIST, MailSortField.RECEIVED_DATE.getField(), Order.DESCENDING, true));
        if (searchR.hasError()) {
            SearchTest.fail((String)searchR.getException().toString());
        }
        JSONArray array = (JSONArray)searchR.getData();
        SearchTest.assertEquals((String)"Unexpected number of search results.", (int)25, (int)array.length());
    }

    public void testNestedComplexSearch() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        MailDateFormat mdf = new MailDateFormat();
        long now = System.currentTimeMillis();
        Date dnow = new Date(now);
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: " + mdf.format(dnow) + "\n" + "From: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        long recDate = now - 86400000L;
        JSONArray searchExpression = new JSONArray("['and', ['>',{'field':'received_date'}, '" + recDate + "'], ['not', ['=', {'field':'flags'},'32']]]");
        JSONObject searchObject = new JSONObject().put("filter", (Object)searchExpression);
        SearchResponse searchR = Executor.execute(this.getSession(), new SearchRequest(searchObject, this.getInboxFolder(), COLUMNS_DEFAULT_LIST, MailSortField.RECEIVED_DATE.getField(), Order.DESCENDING, true));
        if (searchR.hasError()) {
            SearchTest.fail((String)searchR.getException().toString());
        }
        JSONArray array = (JSONArray)searchR.getData();
        SearchTest.assertEquals((String)"Unexpected number of search results.", (int)25, (int)array.length());
    }
}

