/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;

public class DeleteInfostoreRequest
extends AbstractInfostoreRequest<DeleteInfostoreResponse> {
    private List<Integer> ids;
    private List<Integer> folders;
    private Date timestamp;
    private Boolean hardDelete;

    public void setIds(List<Integer> ids) {
        this.ids = ids;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public void setFolders(List<Integer> folders) {
        this.folders = folders;
    }

    public List<Integer> getFolders() {
        return this.folders;
    }

    public void setTimestamp(Date timestamps) {
        this.timestamp = timestamps;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setHardDelete(Boolean hardDelete) {
        this.hardDelete = hardDelete;
    }

    public Boolean isHardDelete() {
        return this.hardDelete;
    }

    public DeleteInfostoreRequest(List<Integer> ids, List<Integer> folders, Date timestamp) {
        this();
        this.setIds(ids);
        this.setFolders(folders);
        this.setTimestamp(timestamp);
    }

    public DeleteInfostoreRequest() {
        this.setIds(new LinkedList<Integer>());
        this.setFolders(new LinkedList<Integer>());
    }

    public DeleteInfostoreRequest(int id, int folder, Date timestamp) {
        this();
        this.setIds(Arrays.asList(id));
        this.setFolders(Arrays.asList(folder));
        this.setTimestamp(timestamp);
    }

    @Override
    public Object getBody() throws JSONException {
        return this.writeFolderAndIDList(this.getIds(), this.getFolders());
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        Params params = new Params("action", "delete", "timestamp", String.valueOf(this.getTimestamp().getTime()));
        if (null != this.hardDelete) {
            params.add("hardDelete", String.valueOf(this.hardDelete));
        }
        return params.toArray();
    }

    @Override
    public AbstractAJAXParser<? extends DeleteInfostoreResponse> getParser() {
        return new AbstractAJAXParser<DeleteInfostoreResponse>(this.getFailOnError()){

            @Override
            protected DeleteInfostoreResponse createResponse(Response response) throws JSONException {
                return new DeleteInfostoreResponse(response);
            }
        };
    }
}

