/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Bug12470Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private TimeZone utc;
    private int objectId = -1;
    private Date lastModified = null;
    private static final String vTodo = "BEGIN:VCALENDAR\nPRODID:-//K Desktop Environment//NONSGML libkcal 3.2//EN\nVERSION:2.0\nBEGIN:VTODO\nDTSTAMP:20070531T093649Z\nORGANIZER;CN=Horst Schmidt:MAILTO:horst.schmidt@example.invalid\nCREATED:20070531T093612Z\nUID:libkcal-1172232934.1028\nSEQUENCE:0\nLAST-MODIFIED:20070531T093612Z\nDESCRIPTION:das ist ein ical test\nSUMMARY:test ical\nLOCATION:daheim\nCLASS:PUBLIC\nPRIORITY:5\nDUE;VALUE=DATE:20070731\nPERCENT-COMPLETE:30\nEND:VTODO\nEND:VCALENDAR\n";

    public Bug12470Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.utc = TimeZone.getTimeZone("UTC");
        this.importvTodo();
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteTask();
        super.tearDown();
    }

    public void testDueDate() throws OXException, IOException, SAXException, JSONException, OXException {
        GetRequest request = new GetRequest(this.folderId, this.objectId);
        GetResponse response = this.client.execute(request);
        Task task = response.getTask(this.tz);
        Date due = task.getEndDate();
        Calendar calendar = TimeTools.createCalendar(this.utc);
        calendar.set(1, 2007);
        calendar.set(2, 6);
        calendar.set(5, 31);
        calendar.set(11, 0);
        Date expected = calendar.getTime();
        Bug12470Test.assertEquals((String)"Task due dates are not correctly imported.", (Object)expected, (Object)due);
    }

    private void importvTodo() throws OXException, IOException, SAXException, JSONException {
        ICalImportRequest request = new ICalImportRequest(this.folderId, vTodo);
        ICalImportResponse response = this.client.execute(request);
        if (response.hasError()) {
            Bug12470Test.fail((String)response.getException().toString());
        }
        ImportResult result = response.getImports()[0];
        this.objectId = Integer.parseInt(result.getObjectId());
    }

    private void deleteTask() throws OXException, IOException, SAXException, JSONException {
        if (null == this.lastModified) {
            this.lastModified = new Date(Long.MAX_VALUE);
        }
        DeleteRequest request = new DeleteRequest(this.folderId, this.objectId, this.lastModified);
        this.client.execute(request);
    }
}

