/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public final class PermissionsHandDownTest
extends AbstractAJAXSession {
    private AJAXClient client2;

    public PermissionsHandDownTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client2) {
            this.client2.logout();
            this.client2 = null;
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testPermissionsHandDown() throws Exception {
        class DeleteInfo {
            int fuid;
            long lastModified;

            DeleteInfo(int fuid, long lastModified) {
                this.fuid = fuid;
                this.lastModified = lastModified;
            }
        }
        LinkedList<DeleteInfo> deletees = new LinkedList<DeleteInfo>();
        try {
            int i;
            String name = "permissions-hand-down_" + System.currentTimeMillis();
            FolderObject folder = Create.createPrivateFolder(name, 1, this.client.getValues().getUserId(), new OCLPermission[0]);
            Date timestamp = null;
            folder.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
            InsertResponse response = this.client.execute(new InsertRequest(EnumAPI.OUTLOOK, folder));
            response.fillObject((DataObject)folder);
            GetResponse response2 = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, folder.getObjectID()));
            timestamp = response2.getTimestamp();
            folder.setLastModified(timestamp);
            deletees.add(new DeleteInfo(folder.getObjectID(), timestamp.getTime()));
            int objectId = folder.getObjectID();
            folder = Create.createPrivateFolder("sub-permissions-hand-down_" + System.currentTimeMillis(), 1, this.client.getValues().getUserId(), new OCLPermission[0]);
            folder.setParentFolderID(objectId);
            InsertResponse response3 = this.client.execute(new InsertRequest(EnumAPI.OUTLOOK, folder));
            response3.fillObject((DataObject)folder);
            GetResponse response22 = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, folder.getObjectID()));
            folder.setLastModified(response22.getTimestamp());
            deletees.add(new DeleteInfo(folder.getObjectID(), response22.getTimestamp().getTime()));
            int childObjectId = folder.getObjectID();
            folder = Create.createPrivateFolder(name, 1, this.client.getValues().getUserId(), new OCLPermission[0]);
            folder.setObjectID(objectId);
            folder.addPermission(Create.ocl(this.client2.getValues().getUserId(), false, false, 2, 2, 0, 0));
            folder.setLastModified(timestamp);
            this.client.execute(new UpdateRequest(EnumAPI.OUTLOOK, folder).setHandDown(true));
            GetResponse getResponse = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, childObjectId));
            List permissions = getResponse.getFolder().getPermissions();
            int pSize = permissions.size();
            PermissionsHandDownTest.assertTrue((String)("Unexpected number of permissions: " + pSize), (pSize > 1 ? 1 : 0) != 0);
            boolean found = false;
            for (i = 0; !found && i < pSize; ++i) {
                found = ((OCLPermission)permissions.get(i)).getEntity() == this.client.getValues().getUserId();
            }
            PermissionsHandDownTest.assertTrue((String)"Folder creator not found in permissions", (boolean)found);
            found = false;
            for (i = 0; !found && i < pSize; ++i) {
                found = ((OCLPermission)permissions.get(i)).getEntity() == this.client2.getValues().getUserId();
            }
            PermissionsHandDownTest.assertTrue((String)"Second user not found in permissions", (boolean)found);
            if (deletees.isEmpty()) return;
        }
        catch (Throwable throwable) {
            if (deletees.isEmpty()) throw throwable;
            Collections.reverse(deletees);
            for (DeleteInfo deleteInfo : deletees) {
                this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, deleteInfo.fuid, new Date(deleteInfo.lastModified)));
            }
            throw throwable;
        }
        Collections.reverse(deletees);
        for (DeleteInfo deleteInfo : deletees) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, deleteInfo.fuid, new Date(deleteInfo.lastModified)));
        }
        return;
    }
}

