/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.mail.utils.MailFolderUtility;
import java.util.Iterator;

public class GetMailInboxTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public GetMailInboxTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testGetMailInbox() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_OLD, String.valueOf(1));
        ListResponse response = this.client.execute(request);
        Iterator<FolderObject> iter = response.getFolder();
        FolderObject defaultIMAPFolder = null;
        String primaryMailFolder = MailFolderUtility.prepareFullname((int)0, (String)"default");
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.containsFullName() || !primaryMailFolder.equals(fo.getFullName())) continue;
            defaultIMAPFolder = fo;
            break;
        }
        GetMailInboxTest.assertNotNull((String)"Default email folder not found.", defaultIMAPFolder);
        GetMailInboxTest.assertTrue((String)"Default email folder has no subfolders.", (boolean)defaultIMAPFolder.hasSubfolders());
        request = new ListRequest((API)EnumAPI.OX_OLD, defaultIMAPFolder.getFullName());
        response = this.client.execute(request);
        iter = response.getFolder();
        FolderObject inboxFolder = null;
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.getFullName().endsWith("INBOX")) continue;
            inboxFolder = fo;
            break;
        }
        GetMailInboxTest.assertNotNull((String)"Inbox folder for default mail account not found.", inboxFolder);
        GetRequest request2 = new GetRequest((API)EnumAPI.OX_OLD, inboxFolder.getFullName(), new int[]{1, 300, 305, 306});
        GetResponse response2 = this.client.execute(request2);
        GetMailInboxTest.assertFalse((String)"Get failed.", (boolean)response2.hasError());
    }
}

