/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.groupware.search.ContactSearchObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactSearchJSONWriter {
    private ContactSearchJSONWriter() {
    }

    public static JSONObject write(ContactSearchObject search) throws JSONException {
        JSONObject json = new JSONObject();
        int[] folders = search.getFolders();
        if (folders != null && folders.length == 1) {
            json.put("folder", folders[0]);
        } else if (folders != null && folders.length > 1) {
            JSONArray folderArray = new JSONArray();
            for (int folder : folders) {
                folderArray.put(folder);
            }
            json.put("folder", (Object)folderArray);
        } else if (-1 != search.getFolder()) {
            json.put("folder", search.getFolder());
        }
        if (ContactSearchObject.NO_PATTERN != search.getPattern()) {
            json.put("pattern", (Object)search.getPattern());
        } else {
            ContactSearchJSONWriter.putSearchFields(search, json);
        }
        return json;
    }

    public static void putSearchFields(ContactSearchObject search, JSONObject json) throws JSONException {
        if (search.getGivenName() != null) {
            json.put("first_name", (Object)search.getGivenName());
        }
        if (search.getSurname() != null) {
            json.put("last_name", (Object)search.getSurname());
        }
        if (search.getDisplayName() != null) {
            json.put("display_name", (Object)search.getDisplayName());
        }
        if (search.getEmail1() != null) {
            json.put("email1", (Object)search.getEmail1());
        }
        if (search.getEmail2() != null) {
            json.put("email2", (Object)search.getEmail2());
        }
        if (search.getEmail3() != null) {
            json.put("email3", (Object)search.getEmail3());
        }
        if (search.isOrSearch()) {
            json.put("orSearch", true);
        }
    }
}

