/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;

public class Bug19827Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Contact contact;

    public Bug19827Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.contact = new Contact();
        this.contact.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        this.contact.setDisplayName("Test for bug 19827");
        this.contact.setStreetBusiness("Business Street 55");
        this.contact.setPostalCodeBusiness("54453");
        this.contact.setCityBusiness("Business City");
        this.contact.setStateBusiness("Business State");
        this.contact.setCountryBusiness("Business Country");
        this.contact.setAddressBusiness("Business Street 55\r\n54453 Business City\r\nBusiness State - Business Country");
        this.contact.setStreetHome("Home Street 55");
        this.contact.setPostalCodeHome("54453");
        this.contact.setCityHome("Home City");
        this.contact.setStateHome("Home State");
        this.contact.setCountryHome("Home Country");
        this.contact.setAddressHome("Home Street 55\r\n54453 Home City\r\nHome State - Home Country");
        this.contact.setStreetOther("Other Street 55");
        this.contact.setPostalCodeOther("54453");
        this.contact.setCityOther("Other City");
        this.contact.setStateOther("Other State");
        this.contact.setCountryOther("Other Country");
        this.contact.setAddressOther("Other Street 55\r\n54453 Other City\r\nOther State - Other Country");
        InsertRequest request = new InsertRequest(this.contact);
        InsertResponse response = this.client.execute(request);
        response.fillObject((DataObject)this.contact);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.contact) {
            this.contact.setLastModified(new Date(Long.MAX_VALUE));
            this.client.execute(new DeleteRequest(this.contact));
        }
        super.tearDown();
    }

    public void testInvalidateBusinessAddress() throws Throwable {
        GetResponse getResponse = this.client.execute(new GetRequest(this.contact, this.client.getValues().getTimeZone()));
        Contact contact = getResponse.getContact();
        contact.removeCreationDate();
        contact.setLastModified(getResponse.getTimestamp());
        contact.setPostalCodeBusiness("99999");
        this.client.execute(new UpdateRequest(contact));
        GetResponse response = this.client.execute(new GetRequest(contact, this.client.getValues().getTimeZone()));
        contact = response.getContact();
        Bug19827Test.assertNull((String)"Business address not invalidated", (Object)contact.getAddressBusiness());
    }

    public void testInvalidateHomeAddress() throws Throwable {
        GetResponse getResponse = this.client.execute(new GetRequest(this.contact, this.client.getValues().getTimeZone()));
        Contact contact = getResponse.getContact();
        contact.removeCreationDate();
        contact.setLastModified(getResponse.getTimestamp());
        contact.setStreetHome("Changed Street 88");
        this.client.execute(new UpdateRequest(contact));
        GetResponse response = this.client.execute(new GetRequest(contact, this.client.getValues().getTimeZone()));
        contact = response.getContact();
        Bug19827Test.assertNull((String)"Home address not invalidated", (Object)contact.getAddressHome());
    }

    public void testInvalidateOtherAddress() throws Throwable {
        GetResponse getResponse = this.client.execute(new GetRequest(this.contact, this.client.getValues().getTimeZone()));
        Contact contact = getResponse.getContact();
        contact.removeCreationDate();
        contact.setLastModified(getResponse.getTimestamp());
        contact.setCountryOther("Another updated country");
        this.client.execute(new UpdateRequest(contact));
        GetResponse response = this.client.execute(new GetRequest(contact, this.client.getValues().getTimeZone()));
        contact = response.getContact();
        Bug19827Test.assertNull((String)"Other address not invalidated", (Object)contact.getAddressOther());
    }
}

