/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;

public class Bug37668Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment app;

    public Bug37668Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.app = new Appointment();
        this.app.setStartDate(TimeTools.D("14.01.2015 16:00"));
        this.app.setEndDate(TimeTools.D("14.01.2015 17:00"));
        this.app.setRecurrenceType(4);
        this.app.setInterval(1);
        this.app.setDayInMonth(27);
        this.app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app.setIgnoreConflicts(true);
    }

    public void testBug37668_JAN() throws Exception {
        this.doTest(0);
    }

    public void testBug37668_FEB() throws Exception {
        this.doTest(1);
    }

    public void testBug37668_MAR() throws Exception {
        this.doTest(2);
    }

    public void testBug37668_APR() throws Exception {
        this.doTest(3);
    }

    public void testBug37668_MAY() throws Exception {
        this.doTest(4);
    }

    public void testBug37668_JUN() throws Exception {
        this.doTest(5);
    }

    public void testBug37668_JUL() throws Exception {
        this.doTest(6);
    }

    public void testBug37668_AUG() throws Exception {
        this.doTest(7);
    }

    public void testBug37668_SEP() throws Exception {
        this.doTest(8);
    }

    public void testBug37668_OCT() throws Exception {
        this.doTest(9);
    }

    public void testBug37668_NOV() throws Exception {
        this.doTest(10);
    }

    public void testBug37668_DEC() throws Exception {
        this.doTest(11);
    }

    private void doTest(int month) throws Exception {
        this.app.setMonth(month);
        this.app.setTitle("Bug 37668 Test (" + (month + 1) + ")");
        this.ctm.insert(this.app);
        Appointment delete = new Appointment();
        delete.setObjectID(this.app.getObjectID());
        delete.setParentFolderID(this.app.getParentFolderID());
        delete.setRecurrencePosition(1);
        delete.setLastModified(new Date(Long.MAX_VALUE));
        this.ctm.delete(delete);
        Appointment load = this.ctm.get(this.app.getParentFolderID(), this.app.getObjectID());
        Bug37668Test.assertEquals((String)"Wrong date.", (Object)TimeTools.D("27." + (month + 1) + ".2015 17:00"), (Object)load.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

