/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.AbstractAppointmentTest;
import com.openexchange.ajax.appointment.AppointmentRangeGenerator;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.java.util.Pair;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bug33697Test
extends AbstractAppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(Bug33697Test.class);
    private AJAXClient.User userX;
    private AJAXClient.User userY;
    private AJAXClient.User userZ;
    private AJAXClient clientX;
    private AJAXClient clientY;
    private AJAXClient clientZ;
    private UserValues userValuesX;
    private UserValues userValuesY;
    private UserValues userValuesZ;
    private Appointment bug33697Appointment;
    private FolderObject bug33697SubfolderX;
    private FolderObject bug33697SubfolderY;
    private FolderObject bug33697SubfolderZ;

    public Bug33697Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.userX = AJAXClient.User.User1;
        this.userY = AJAXClient.User.User2;
        this.userZ = AJAXClient.User.User3;
        this.clientX = this.client;
        this.clientY = new AJAXClient(this.userY);
        this.clientZ = new AJAXClient(this.userZ);
        this.userValuesX = this.clientX.getValues();
        this.userValuesY = this.clientY.getValues();
        this.userValuesZ = this.clientZ.getValues();
        this.bug33697SubfolderX = this.createCalendarSubFolder(this.clientX, "Bug33697SubfolderX", Bug33697Test.createOwnerPermission(this.userValuesX.getUserId()), Bug33697Test.createAuthorPermission(this.userValuesY.getUserId()));
        this.bug33697SubfolderY = this.createCalendarSubFolder(this.clientY, "Bug33697SubfolderY", Bug33697Test.createOwnerPermission(this.userValuesY.getUserId()));
        this.bug33697SubfolderZ = this.createCalendarSubFolder(this.clientZ, "Bug33697SubfolderZ", Bug33697Test.createOwnerPermission(this.userValuesZ.getUserId()), Bug33697Test.createAuthorPermission(this.userValuesY.getUserId()));
        AppointmentRangeGenerator.AppointmentRange dateRange = this.appointmentRangeGenerator.getDateRange();
        this.bug33697Appointment = this.createSingle(dateRange.startDate, dateRange.endDate, "Bug33697Appointment");
        this.bug33697Appointment.setParentFolderID(this.bug33697SubfolderX.getObjectID());
        this.persistAppointment(this.clientX, this.bug33697Appointment);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.deleteAppointments(this.clientX, this.getAppointment(this.clientX, this.userValuesX.getPrivateAppointmentFolder(), this.bug33697Appointment.getObjectID()));
        this.deleteCalendarFolder(this.clientX, this.bug33697SubfolderX);
        this.deleteCalendarFolder(this.clientY, this.bug33697SubfolderY);
        this.deleteCalendarFolder(this.clientZ, this.bug33697SubfolderZ);
        this.clientX.logout();
        this.clientY.logout();
        this.clientZ.logout();
    }

    public void testMoveFromUserXSharedSubFolderToUserYPrivateSubFolder() throws Exception {
        this.bug33697Appointment.setParentFolderID(this.bug33697SubfolderY.getObjectID());
        Pair pair = new Pair((Object)this.bug33697Appointment, (Object)this.bug33697SubfolderX);
        this.updateAppointmentsWithOrigin(this.clientY, Collections.singletonList(pair));
        Appointment appointmentViewForX = null;
        try {
            appointmentViewForX = this.getAppointment(this.clientX, this.userValuesX.getPrivateAppointmentFolder(), this.bug33697Appointment.getObjectID());
        }
        catch (Exception e) {
            LOG.error("Error while getting appointment view for userX", (Throwable)e);
        }
        Bug33697Test.assertNotNull((String)("Moved appointment should have been found in folder: " + this.userValuesX.getPrivateAppointmentFolder()), (Object)appointmentViewForX);
        Appointment appointmentViewForY = null;
        try {
            appointmentViewForY = this.getAppointment(this.clientY, this.bug33697SubfolderY.getObjectID(), this.bug33697Appointment.getObjectID());
        }
        catch (Exception e) {
            LOG.error("Error while getting appointment view for userY", (Throwable)e);
        }
        Bug33697Test.assertNotNull((String)("Moved appointment should have been found in folder: " + this.bug33697SubfolderY), (Object)appointmentViewForY);
        Participant[] participants = appointmentViewForY.getParticipants();
        Bug33697Test.assertEquals((String)"Appointment should have exactly 2 participants", (int)2, (int)participants.length);
        int[] participantIds = new int[]{participants[0].getIdentifier(), participants[1].getIdentifier()};
        Arrays.sort((int[])participantIds);
        int[] clientIds = new int[]{this.userValuesX.getUserId(), this.userValuesY.getUserId()};
        Arrays.sort((int[])clientIds);
        Bug33697Test.assertTrue((String)"Participants and clients should be equal for the moved appointment", (boolean)Arrays.equals((int[])participantIds, (int[])clientIds));
    }
}

