/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;

public class Bug29566Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private CalendarTestManager ctm;
    private CalendarTestManager ctm2;
    private Appointment appointment;

    public Bug29566Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm = new CalendarTestManager(this.client);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.appointment = new Appointment();
        this.appointment.setStartDate(TimeTools.D("18.11.2013 08:00"));
        this.appointment.setEndDate(TimeTools.D("18.11.2013 09:00"));
        this.appointment.setTitle("Test Bug 29146");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        this.appointment.setParticipants(new Participant[]{user});
        this.appointment.setUsers(new UserParticipant[]{user});
    }

    public void testAddParticipantWithExternalOrganizerAndUid() throws Exception {
        this.addParticipantWithExternalOrganizerAndUid(false);
    }

    public void testAddParticipantWithExternalOrganizerAndUidShared() throws Exception {
        this.addParticipantWithExternalOrganizerAndUid(true);
    }

    private void addParticipantWithExternalOrganizerAndUid(boolean shared) throws Exception {
        String uid = this.generateUid();
        this.appointment.setUid(uid);
        String organizer = "test@extern.example.invalid";
        this.appointment.setOrganizer(organizer);
        this.ctm.insert(this.appointment);
        Appointment clone = this.appointment.clone();
        if (!shared) {
            clone.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        }
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        user2.setConfirm(0);
        clone.setParticipants(new Participant[]{user, user2});
        clone.setUsers(new UserParticipant[]{user, user2});
        this.ctm2.update(clone);
        if (shared) {
            Bug29566Test.assertTrue((String)"Error expected.", (boolean)this.ctm2.getLastResponse().hasError());
            Bug29566Test.assertEquals((String)"Wrong error.", (int)OXCalendarExceptionCodes.NO_SHARED_FOLDER_OWNER.getNumber(), (int)this.ctm2.getLastResponse().getException().getCode());
        } else {
            Bug29566Test.assertFalse((String)"No error expected.", (boolean)this.ctm2.getLastResponse().hasError());
            Appointment loaded = this.ctm.get(this.appointment);
            Bug29566Test.assertEquals((String)"Expected two participants.", (int)2, (int)loaded.getParticipants().length);
            Bug29566Test.assertEquals((String)"Expected two users.", (int)2, (int)loaded.getUsers().length);
        }
    }

    public void testAddParticipantWithoutInfoShared() throws Exception {
        this.addParticipantWithoutInfo(true);
    }

    public void testAddParticipantWithoutInfo() throws Exception {
        this.addParticipantWithoutInfo(false);
    }

    private void addParticipantWithoutInfo(boolean shared) throws Exception {
        String uid = this.generateUid();
        this.appointment.setUid(uid);
        String organizer = "test@extern.example.invalid";
        this.appointment.setOrganizer(organizer);
        this.ctm.insert(this.appointment);
        Appointment clone = this.appointment.clone();
        clone.removeOrganizer();
        clone.removeUid();
        if (!shared) {
            clone.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        }
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        user2.setConfirm(0);
        clone.setParticipants(new Participant[]{user, user2});
        clone.setUsers(new UserParticipant[]{user, user2});
        this.ctm2.update(clone);
        AbstractAJAXResponse updateResponse = this.ctm2.getLastResponse();
        Bug29566Test.assertTrue((String)"Should fail.", (boolean)updateResponse.hasError());
        Bug29566Test.assertEquals((String)"Wrong error.", (int)(shared ? OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_5.getNumber() : OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_2.getNumber()), (int)updateResponse.getException().getCode());
    }

    public void testAddParticipantWithOnlyExternalOrganizer() throws Exception {
        this.addParticipantWithOnlyExternalOrganizer(false);
    }

    public void testAddParticipantWithOnlyExternalOrganizerShared() throws Exception {
        this.addParticipantWithOnlyExternalOrganizer(true);
    }

    private void addParticipantWithOnlyExternalOrganizer(boolean shared) throws Exception {
        String uid = this.generateUid();
        this.appointment.setUid(uid);
        String organizer = "test@extern.example.invalid";
        this.appointment.setOrganizer(organizer);
        this.ctm.insert(this.appointment);
        Appointment clone = this.appointment.clone();
        clone.removeUid();
        if (!shared) {
            clone.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        }
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        user2.setConfirm(0);
        clone.setParticipants(new Participant[]{user, user2});
        clone.setUsers(new UserParticipant[]{user, user2});
        this.ctm2.update(clone);
        AbstractAJAXResponse updateResponse = this.ctm2.getLastResponse();
        Bug29566Test.assertTrue((String)"Should fail.", (boolean)updateResponse.hasError());
        Bug29566Test.assertEquals((String)"Wrong error.", (int)(shared ? OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_5.getNumber() : OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_2.getNumber()), (int)updateResponse.getException().getCode());
    }

    public void testAddParticipantWithOnlyUid() throws Exception {
        this.addParticipantWithOnlyUid(false);
    }

    public void testAddParticipantWithOnlyUidShared() throws Exception {
        this.addParticipantWithOnlyUid(true);
    }

    private void addParticipantWithOnlyUid(boolean shared) throws Exception {
        String uid = this.generateUid();
        this.appointment.setUid(uid);
        String organizer = "test@extern.example.invalid";
        this.appointment.setOrganizer(organizer);
        this.ctm.insert(this.appointment);
        Appointment clone = this.appointment.clone();
        clone.removeOrganizer();
        if (!shared) {
            clone.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        }
        UserParticipant user = new UserParticipant(this.client.getValues().getUserId());
        user.setConfirm(0);
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        user2.setConfirm(0);
        clone.setParticipants(new Participant[]{user, user2});
        clone.setUsers(new UserParticipant[]{user, user2});
        this.ctm2.update(clone);
        AbstractAJAXResponse updateResponse = this.ctm2.getLastResponse();
        Bug29566Test.assertTrue((String)"Should fail.", (boolean)updateResponse.hasError());
        Bug29566Test.assertEquals((String)"Wrong error.", (int)(shared ? OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_5.getNumber() : OXCalendarExceptionCodes.LOAD_PERMISSION_EXCEPTION_2.getNumber()), (int)updateResponse.getException().getCode());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }

    private String generateUid() {
        return "UID" + System.currentTimeMillis();
    }
}

