/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;

public class Bug14679Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment update;

    public Bug14679Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 14679 Test");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setStartDate(TimeTools.D("19.10.2009 12:30", TimeZone.getTimeZone("UTC")));
        this.appointment.setEndDate(TimeTools.D("19.10.2009 13:30", TimeZone.getTimeZone("UTC")));
        this.appointment.setRecurrenceType(2);
        this.appointment.setInterval(1);
        this.appointment.setDays(10);
        this.appointment.setUntil(TimeTools.D("30.12.2009 00:00", TimeZone.getTimeZone("UTC")));
        this.appointment.setIgnoreConflicts(true);
        InsertRequest appointmentInsertRequest = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse appointmentInsertResponse = this.getClient().execute(appointmentInsertRequest);
        appointmentInsertResponse.fillAppointment(this.appointment);
        this.update = new Appointment();
        this.update.setObjectID(this.appointment.getObjectID());
        this.update.setParentFolderID(this.appointment.getParentFolderID());
        this.update.setLastModified(this.appointment.getLastModified());
        this.update.setRecurrenceType(2);
        this.update.setInterval(2);
        this.update.setDays(10);
        this.update.setUntil(TimeTools.D("30.12.2009 00:00", TimeZone.getTimeZone("UTC")));
        this.update.setIgnoreConflicts(true);
    }

    public void testBug() throws Exception {
        UpdateRequest updateRequest = new UpdateRequest(this.update, this.client.getValues().getTimeZone());
        UpdateResponse updateResponse = this.client.execute(updateRequest);
        this.appointment.setLastModified(updateResponse.getTimestamp());
        int[] columns = new int[]{1};
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), columns, TimeTools.D("01.11.2009 00:00", TimeZone.getTimeZone("UTC")), TimeTools.D("01.12.2009 00:00", TimeZone.getTimeZone("UTC")), TimeZone.getTimeZone("UTC"), false);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        Object[][] objects = allResponse.getArray();
        int count = 0;
        for (Object[] object : objects) {
            if (((Integer)object[0]).intValue() != this.appointment.getObjectID()) continue;
            ++count;
        }
        Bug14679Test.assertEquals((String)"Wrong amount of occurrences.", (int)5, (int)count);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest appointmentDeleteRequest = new DeleteRequest(this.appointment);
        this.getClient().execute(appointmentDeleteRequest);
        super.tearDown();
    }
}

