/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class FixedExecutorService
extends AbstractExecutorService {
    private final ExecutorService executorService;
    private final Lock lock = new ReentrantLock();
    private final BlockingQueue<Runnable> queue;
    private final int size;
    private final AtomicInteger count;

    public FixedExecutorService(int size, ExecutorService executorService) {
        this.size = size;
        this.queue = new LinkedBlockingQueue<Runnable>();
        this.count = new AtomicInteger();
        this.executorService = executorService;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        this.lock.lock();
        try {
            if (this.queue.isEmpty() && this.count.get() < this.size) {
                this.count.incrementAndGet();
                this.executorService.execute(new PollingFuture(command));
            } else {
                this.queue.offer(command);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pollFromQueue() {
        this.lock.lock();
        try {
            Runnable command = (Runnable)this.queue.poll();
            if (null != command) {
                this.executorService.execute(new PollingFuture(command));
                boolean bl = true;
                return bl;
            }
            this.count.decrementAndGet();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("Shutdown not allowed.");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("Shutdown not allowed.");
    }

    private final class PollingFuture
    extends FutureTask<Object> {
        public PollingFuture(Runnable command) {
            super(command, null);
        }

        @Override
        protected void done() {
            FixedExecutorService.this.pollFromQueue();
        }
    }
}

