/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.RefusedExecutionBehavior;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.CustomFutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public final class DelegatingRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final RejectedExecutionHandler defaultHandler;
    private final ThreadPoolService threadPool;

    public DelegatingRejectedExecutionHandler(RejectedExecutionHandler defaultHandler, ThreadPoolService threadPool) {
        this.defaultHandler = defaultHandler;
        this.threadPool = threadPool;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (r instanceof CustomFutureTask) {
            CustomFutureTask cft = (CustomFutureTask)r;
            try {
                this.handleTask(cft);
            }
            catch (RejectedExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                cft.setException(e);
            }
        }
        this.defaultHandler.rejectedExecution(r, executor);
    }

    private <V> void handleTask(CustomFutureTask<V> cft) throws Exception {
        V result;
        RefusedExecutionBehavior<V> reb = cft.getRefusedExecutionBehavior();
        if (null != reb && RefusedExecutionBehavior.DISCARDED != (result = reb.refusedExecution(cft.getTask(), this.threadPool))) {
            cft.set(result);
        }
    }
}

