/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.tools.mappings.MappedTruncation;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactFolderMultipleUpdaterStrategy
implements FolderUpdaterStrategy<Contact> {
    private static final int SQL_INTERFACE = 1;
    private static final int TARGET = 2;
    private static final int SESSION = 3;
    private static final Logger LOG = LoggerFactory.getLogger(ContactFolderMultipleUpdaterStrategy.class);
    private static final ContactField[] COMPARISON_FIELDS = ContactField.values();

    @Override
    public int calculateSimilarityScore(Contact original, Contact candidate, Object session) throws OXException {
        int score = 0;
        int threshhold = this.getThreshold(session);
        if ((this.isset(original.getGivenName()) || this.isset(candidate.getGivenName())) && this.eq(original.getGivenName(), candidate.getGivenName())) {
            score += 5;
        }
        if ((this.isset(original.getSurName()) || this.isset(candidate.getSurName())) && this.eq(original.getSurName(), candidate.getSurName())) {
            score += 5;
        }
        if ((this.isset(original.getDisplayName()) || this.isset(candidate.getDisplayName())) && this.eq(original.getDisplayName(), candidate.getDisplayName())) {
            score += 10;
        }
        if (this.eq(original.getEmail1(), candidate.getEmail1())) {
            score += 10;
        }
        if (this.eq(original.getEmail2(), candidate.getEmail2())) {
            score += 10;
        }
        if (this.eq(original.getEmail3(), candidate.getEmail3())) {
            score += 10;
        }
        if (this.eq(original.getCellularTelephone1(), candidate.getCellularTelephone1())) {
            score += 10;
        }
        if (original.containsBirthday() && candidate.containsBirthday() && this.eq(original.getBirthday(), candidate.getBirthday())) {
            score += 5;
        }
        if (score < threshhold && original.equalsContentwise((Object)candidate)) {
            score += threshhold + 1;
        }
        return score;
    }

    private boolean isset(String s) {
        return s == null || s.length() > 0;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void closeSession(Object session) throws OXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Contact> getData(TargetFolderDefinition target, Object session) throws OXException {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        ContactService contactService = (ContactService)this.getFromSession(1, session);
        TargetFolderSession targetFolderSession = (TargetFolderSession)this.getFromSession(3, session);
        SearchIterator searchIterator = null;
        try {
            searchIterator = contactService.getAllContacts((Session)targetFolderSession, target.getFolderId(), COMPARISON_FIELDS);
            if (null != searchIterator) {
                while (searchIterator.hasNext()) {
                    contacts.add((Contact)searchIterator.next());
                }
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        return contacts;
    }

    @Override
    public int getThreshold(Object session) throws OXException {
        return 9;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return folder.getModule() == 3;
    }

    @Override
    public void save(Contact newElement, Object session) throws OXException {
        ContactService contactService = (ContactService)this.getFromSession(1, session);
        TargetFolderSession targetFolderSession = (TargetFolderSession)this.getFromSession(3, session);
        TargetFolderDefinition target = (TargetFolderDefinition)this.getFromSession(2, session);
        newElement.setParentFolderID(target.getFolderIdAsInt());
        try {
            contactService.createContact((Session)targetFolderSession, target.getFolderId(), newElement);
        }
        catch (OXException e) {
            if (ContactExceptionCodes.DATA_TRUNCATION.equals(e)) {
                boolean hasTrimmed = false;
                try {
                    hasTrimmed = MappedTruncation.truncate((OXException.ProblematicAttribute[])e.getProblematics(), (Object)newElement);
                }
                catch (OXException x) {
                    LOG.warn("error trying to handle truncated attributes", (Throwable)x);
                }
                if (hasTrimmed) {
                    this.save(newElement, session);
                    return;
                }
            }
            throw e;
        }
    }

    private Object getFromSession(int key, Object session) {
        return ((Map)session).get(key);
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        HashMap<Integer, Object> userInfo = new HashMap<Integer, Object>();
        TargetFolderSession session = new TargetFolderSession(target);
        ContactService contactService = (ContactService)SubscriptionServiceRegistry.getInstance().getService(ContactService.class);
        userInfo.put(1, contactService);
        userInfo.put(2, target);
        userInfo.put(3, session);
        return userInfo;
    }

    @Override
    public void update(Contact original, Contact update, Object session) throws OXException {
        ContactService contactService = (ContactService)this.getFromSession(1, session);
        TargetFolderSession targetFolderSession = (TargetFolderSession)this.getFromSession(3, session);
        String folderId = Integer.toString(original.getParentFolderID());
        String contactId = Integer.toString(original.getObjectID());
        Contact origContact = original;
        int retry = 2;
        while (retry-- > 0) {
            int[] columns;
            for (int field : columns = Contact.CONTENT_COLUMNS) {
                Object newValue;
                if (origContact.get(field) != null || (newValue = update.get(field)) == null) continue;
                origContact.set(field, newValue);
            }
            if (origContact.getImage1() != null && origContact.getImageContentType() == null) {
                String imageContentType = update.getImageContentType();
                if (null == imageContentType) {
                    imageContentType = "image/jpeg";
                }
                origContact.setImageContentType(imageContentType);
            }
            try {
                contactService.updateContact((Session)targetFolderSession, folderId, contactId, origContact, origContact.getLastModified());
            }
            catch (OXException e) {
                if (!ContactExceptionCodes.OBJECT_HAS_CHANGED.equals(e) || retry <= 0) {
                    throw e;
                }
                origContact = contactService.getContact((Session)targetFolderSession, folderId, contactId, COMPARISON_FIELDS);
            }
        }
    }
}

