/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.internal.ContactFolderUpdaterStrategy;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import java.util.Date;
import junit.framework.TestCase;
import org.junit.Test;

public class ContactFolderUpdaterStrategyTest
extends TestCase {
    private FolderUpdaterStrategy<Contact> strategy;

    public void setUp() {
        this.strategy = new ContactFolderUpdaterStrategy();
    }

    public void testHandles() {
        FolderObject contactFolder = new FolderObject();
        contactFolder.setModule(3);
        FolderObject infostoreFolder = new FolderObject();
        infostoreFolder.setModule(8);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Should handle contact folders", (boolean)this.strategy.handles(contactFolder));
        ContactFolderUpdaterStrategyTest.assertFalse((String)"Should not handle infostore folders", (boolean)this.strategy.handles(infostoreFolder));
    }

    public void testScoring() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setSurName("Wurst");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"First name should not be enough", (score < this.strategy.getThreshold(null) ? 1 : 0) != 0);
        contact2.setSurName("Dampf");
        score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"First name and last name is not enough", (score > this.strategy.getThreshold(null) ? 1 : 0) != 0);
        contact.setBirthday(new Date(2L));
        contact2.setBirthday(new Date(2L));
        int newScore = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Similarity score for matching birthdays should be bigger", (newScore > score ? 1 : 0) != 0);
    }

    public void testTwoCompaniesDiffer() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("");
        contact.setSurName("");
        contact.setCompany("Wunderwerk GmbH");
        Contact contact2 = new Contact();
        contact2.setGivenName("");
        contact2.setSurName("");
        contact2.setCompany("Schokoladenfabrik Inc.");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Empty names shouldn't be considered equal.", (score < this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }

    public void testNameChangedButMailAdressStayedTheSame() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setEmail1("hans@example.com");
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setSurName("Wurst");
        contact2.setEmail1("hans@example.com");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"First name and email address should suffice", (score >= this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }

    public void testNullValuesShouldNotChangeResult() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setEmail1(null);
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setEmail1(null);
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Two objects with similar content should match", (score > this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }

    public void testTwoEmptyContactsAreTheSame() throws OXException {
        Contact contact = new Contact();
        Contact contact2 = new Contact();
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Two completely empty objects should match, too", (score > this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateSimilarityScore_mobileEqual_increaseSimilarityScore() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setCellularTelephone1("0000-0000000");
        Contact candidate = new Contact();
        candidate.setGivenName("Hans");
        candidate.setEmail1("hans@example.com");
        candidate.setCellularTelephone1("0000-0000000");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)candidate, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Score to low. CellularTelephone is equal.", (score >= this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateSimilarityScore_mobileDifferent_smallScore() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setCellularTelephone1("0000-0000000");
        Contact candidate = new Contact();
        candidate.setGivenName("Hans");
        candidate.setEmail1("hans@example.com");
        candidate.setCellularTelephone1("1111-1111111");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)candidate, null);
        ContactFolderUpdaterStrategyTest.assertTrue((String)"Score to high. Only GivenName is equal.", (score < this.strategy.getThreshold(null) ? 1 : 0) != 0);
    }
}

