/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.internal.ContactFolderMultipleUpdaterStrategy;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContactFolderMultipleUpdaterStrategyTest {
    private FolderUpdaterStrategy<Contact> strategy;
    private HashMap<Integer, Object> session;

    @Before
    public void setUp() {
        this.strategy = new ContactFolderMultipleUpdaterStrategy();
        this.session = new HashMap();
    }

    @Test
    public void testHandles() {
        FolderObject contactFolder = new FolderObject();
        contactFolder.setModule(3);
        FolderObject infostoreFolder = new FolderObject();
        infostoreFolder.setModule(8);
        Assert.assertTrue((String)"Should handle contact folders", (boolean)this.strategy.handles(contactFolder));
        Assert.assertFalse((String)"Should not handle infostore folders", (boolean)this.strategy.handles(infostoreFolder));
    }

    @Test
    public void testScoring() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setUserField20(UUID.randomUUID().toString());
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setSurName("Wurst");
        contact2.setUserField20(UUID.randomUUID().toString());
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"First name should not be enough", (score < this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
        contact2.setSurName("Dampf");
        score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"First name and last name is enough", (score > this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
        contact.setBirthday(new Date(2L));
        contact2.setBirthday(new Date(2L));
        int newScore = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"Similarity score for matching birthdays should be bigger", (newScore > score ? 1 : 0) != 0);
    }

    @Test
    public void testTwoCompaniesDiffer() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("");
        contact.setSurName("");
        contact.setUserField20(UUID.randomUUID().toString());
        contact.setCompany("Wunderwerk GmbH");
        Contact contact2 = new Contact();
        contact2.setGivenName("");
        contact2.setSurName("");
        contact2.setCompany("Schokoladenfabrik Inc.");
        contact2.setUserField20(UUID.randomUUID().toString());
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"Empty names shouldn't be considered equal.", (score < this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
    }

    @Test
    public void testNameChangedButMailAdressStayedTheSame() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setEmail1("hans@example.com");
        contact.setUserField20(UUID.randomUUID().toString());
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setSurName("Wurst");
        contact2.setEmail1("hans@example.com");
        contact2.setUserField20(UUID.randomUUID().toString());
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"First name and email address should suffice", (score >= this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
    }

    @Test
    public void testWithoutUUIDNoMagicWillHappen() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setEmail1("hans@example.com");
        contact.setUserField20(UUID.randomUUID().toString());
        Contact contact2 = new Contact();
        contact2.setGivenName("Peter");
        contact2.setSurName("Schmitt");
        contact2.setEmail2("peter@example.com");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"These two contacts should not score higher than the treshhold", (score < this.strategy.getThreshold((Object)contact2) ? 1 : 0) != 0);
    }

    @Test
    public void testSecondContactHasUUIDButIsNotOnThisSystem() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setEmail1("hans@example.com");
        contact.setUserField20(UUID.randomUUID().toString());
        Contact contact2 = new Contact();
        contact2.setGivenName("Peter");
        contact2.setSurName("Schmitt");
        contact2.setEmail2("peter@example.com");
        contact2.setUserField20(UUID.randomUUID().toString());
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"These two contacts should not score higher than the treshhold", (score < this.strategy.getThreshold((Object)contact2) ? 1 : 0) != 0);
    }

    @Test
    public void testTwoContactsAreSimilarButWillNotBeAssociatedBecauseOneIsNotOnTheSystem() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setSurName("Dampf");
        contact.setEmail1("hans@example.com");
        contact.setUserField20(UUID.randomUUID().toString());
        Contact contact2 = new Contact();
        contact2.setGivenName("Hans");
        contact2.setSurName("Dampf");
        contact2.setEmail2("hd@privat.com");
        contact2.setUserField20(UUID.randomUUID().toString());
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)contact2, this.session);
        Assert.assertTrue((String)"These two contacts are similar and should be merged", (score >= this.strategy.getThreshold((Object)contact2) ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateSimilarityScore_mobileEqual_increaseSimilarityScore() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setCellularTelephone1("0000-0000000");
        Contact candidate = new Contact();
        candidate.setGivenName("Hans");
        candidate.setEmail1("hans@example.com");
        candidate.setCellularTelephone1("0000-0000000");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)candidate, this.session);
        Assert.assertTrue((String)"Score to low. CellularTelephone is equal.", (score >= this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateSimilarityScore_mobileDifferent_smallScore() throws OXException {
        Contact contact = new Contact();
        contact.setGivenName("Hans");
        contact.setCellularTelephone1("0000-0000000");
        Contact candidate = new Contact();
        candidate.setGivenName("Hans");
        candidate.setEmail1("hans@example.com");
        candidate.setCellularTelephone1("1111-1111111");
        int score = this.strategy.calculateSimilarityScore((Object)contact, (Object)candidate, this.session);
        Assert.assertTrue((String)"Score to high. Only GivenName is equal.", (score < this.strategy.getThreshold(this.session) ? 1 : 0) != 0);
    }
}

