/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.resource.Resource;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.version.Version;
import com.openexchange.webdav.PermissionServlet;
import com.openexchange.webdav.xml.DataWriter;
import com.openexchange.webdav.xml.GroupUserWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class groupuser
extends PermissionServlet {
    private static final String STR_OBJECTSTATUS_OLD = "objectstatus";
    private static final String STR_CREATE = "CREATE";
    private static final String STR_DELETE = "DELETE";
    private static final long serialVersionUID = -2041907156379627530L;
    private static final String STR_OBJECTSTATUS = "object_status";
    private static String DELETED_GROUP_SQL = "SELECT id, lastmodified FROM del_groups WHERE cid=? AND lastmodified > ?";
    private static String DELETED_RESOURCE_SQL = "SELECT id, lastmodified FROM del_resource WHERE cid=? AND lastmodified > ?";
    private static final transient Logger LOG = LoggerFactory.getLogger(groupuser.class);

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_XML;
    }

    @Override
    public void doPropFind(HttpServletRequest req, HttpServletResponse resp) {
        LOG.debug("PROPFIND");
        String s_user = null;
        String s_group = null;
        String s_resource = null;
        Document input_doc = null;
        Date lastsync = null;
        XMLOutputter xo = new XMLOutputter();
        Session sessionObj = null;
        ServletOutputStream os = null;
        try {
            Element eLastsync;
            Element eResource;
            Element eGroup;
            sessionObj = groupuser.getSession(req);
            Context ctx = ContextStorage.getInstance().getContext(sessionObj.getContextId());
            input_doc = this.getJDOMDocument(req);
            resp.setContentType("text/xml; charset=UTF-8");
            os = resp.getOutputStream();
            resp.setStatus(207);
            if (input_doc == null) {
                this.doError(resp, 400, "Bad Request");
                return;
            }
            Element el = input_doc.getRootElement();
            Element prop = el.getChild("prop", Namespace.getNamespace((String)"D", (String)"DAV:"));
            Element eUser = prop.getChild("user", XmlServlet.NS);
            if (eUser != null) {
                s_user = eUser.getText();
            }
            if ((eGroup = prop.getChild("group", XmlServlet.NS)) != null) {
                s_group = eGroup.getText();
            }
            if ((eResource = prop.getChild("resource", XmlServlet.NS)) != null) {
                s_resource = eResource.getText();
            }
            if ((eLastsync = prop.getChild("lastsync", XmlServlet.NS)) != null) {
                try {
                    lastsync = new Date(Long.parseLong(eLastsync.getText()));
                }
                catch (NumberFormatException exc) {
                    LOG.debug("lastsync is not an integer", (Throwable)exc);
                }
            }
            os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n".getBytes());
            os.write(("<D:multistatus xmlns:D=\"DAV:\" version=\"" + Version.getInstance().getVersionString() + "\" buildname=\"" + "Open-Xchange" + "\">").getBytes());
            os.write("<D:response xmlns:ox=\"http://www.open-xchange.org\">".getBytes());
            os.write("<D:propstat><D:prop>".getBytes());
            if (s_user != null) {
                os.write("<ox:users>".getBytes());
                os.flush();
                User userObj = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
                GroupUserWriter groupuserwriter = new GroupUserWriter(userObj, ctx, sessionObj, new Element("user", XmlServlet.NS));
                if ("*".equals(s_user)) {
                    groupuserwriter.startWriter(true, true, lastsync, (OutputStream)os);
                } else {
                    groupuserwriter.startWriter(s_user, (OutputStream)os);
                }
                os.write("</ox:users>".getBytes());
            }
            if (s_group != null) {
                this.writeElementGroups(s_group, lastsync, (OutputStream)os, xo, ctx);
            }
            if (s_resource != null) {
                this.writeElementResources(s_resource, lastsync, (OutputStream)os, xo, ctx);
            }
            os.write("</D:prop></D:propstat>".getBytes());
            Element status = new Element("status", "D", "DAV:");
            status.addContent("HTTP/1.1 200 OK");
            xo.output(status, (OutputStream)os);
            Element descr = new Element("responsedescription", "D", "DAV:");
            descr.addContent("HTTP/1.1 200 OK");
            xo.output(descr, (OutputStream)os);
            os.write("</D:response>".getBytes());
            os.write("</D:multistatus>".getBytes());
            os.flush();
        }
        catch (Exception exc) {
            LOG.error("doPropFind", (Throwable)exc);
            this.doError(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElementGroups(String s_groups, Date lastsync, OutputStream os, XMLOutputter xo, Context ctx) throws IOException, OXException, SQLException {
        os.write("<ox:groups>".getBytes());
        GroupStorage groupstorage = GroupStorage.getInstance();
        Group[] group = null;
        group = lastsync == null ? (s_groups == null || s_groups.equals("*") ? groupstorage.getGroups(true, ctx) : groupstorage.searchGroups(s_groups, true, ctx)) : groupstorage.listModifiedGroups(lastsync, ctx);
        for (int a = 0; a < group.length; ++a) {
            this.writeElementGroup(group[a], xo, os, false);
        }
        if (lastsync != null) {
            Connection readCon = null;
            PreparedStatement ps = null;
            try {
                readCon = DBPool.pickup(ctx);
                ps = readCon.prepareStatement(DELETED_GROUP_SQL);
                ps.setInt(1, ctx.getContextId());
                ps.setTimestamp(2, new Timestamp(lastsync.getTime()));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Group g = new Group();
                    g.setIdentifier(rs.getInt(1));
                    g.setLastModified(new Date(rs.getLong(2)));
                    this.writeElementGroup(g, xo, os, true);
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqle) {
                        LOG.warn("Error closing PreparedStatement");
                    }
                }
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
        }
        os.write("</ox:groups>".getBytes());
        os.flush();
    }

    private void writeElementGroup(Group group, XMLOutputter xo, OutputStream os, boolean delete) throws IOException {
        Element e_group = new Element("group", XmlServlet.NS);
        if (delete) {
            DataWriter.addElement(STR_OBJECTSTATUS, STR_DELETE, e_group);
            DataWriter.addElement(STR_OBJECTSTATUS_OLD, STR_DELETE, e_group);
        } else {
            DataWriter.addElement(STR_OBJECTSTATUS, STR_CREATE, e_group);
            DataWriter.addElement(STR_OBJECTSTATUS_OLD, STR_CREATE, e_group);
        }
        DataWriter.addElement("uid", group.getIdentifier(), e_group);
        DataWriter.addElement("last_modified", group.getLastModified(), e_group);
        String displayName = group.getDisplayName();
        if (displayName != null) {
            DataWriter.addElement("displayname", displayName, e_group);
        }
        Element e_members = new Element("members", XmlServlet.NS);
        int[] members = group.getMember();
        if (members != null) {
            for (int a = 0; a < members.length; ++a) {
                this.writeElementMember(members[a], e_members);
            }
        }
        e_group.addContent((Content)e_members);
        xo.output(e_group, os);
        os.flush();
    }

    private void writeElementMember(int member, Element e_members) {
        DataWriter.addElement("memberuid", member, e_members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElementResources(String s_resources, Date lastsync, OutputStream os, XMLOutputter xo, Context ctx) throws IOException, OXException, SQLException {
        os.write("<ox:resources>".getBytes());
        ResourceStorage resourcestorage = ResourceStorage.getInstance();
        Resource[] resource = null;
        resource = lastsync == null ? resourcestorage.searchResources(s_resources, ctx) : resourcestorage.listModified(lastsync, ctx);
        for (int a = 0; a < resource.length; ++a) {
            this.writeElementResource(resource[a], xo, os, false);
        }
        if (lastsync != null) {
            Connection readCon = null;
            PreparedStatement ps = null;
            try {
                readCon = DBPool.pickup(ctx);
                ps = readCon.prepareStatement(DELETED_RESOURCE_SQL);
                ps.setInt(1, ctx.getContextId());
                ps.setLong(2, lastsync.getTime());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    Resource r = new Resource();
                    r.setIdentifier(rs.getInt(1));
                    r.setLastModified(new Date(rs.getLong(2)));
                    this.writeElementResource(r, xo, os, true);
                }
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqle) {
                        LOG.warn("Error closing PreparedStatement");
                    }
                }
                if (readCon != null) {
                    DBPool.closeReaderSilent(ctx, readCon);
                }
            }
        }
        os.write("</ox:resources>".getBytes());
        os.flush();
    }

    private void writeElementResource(Resource resource, XMLOutputter xo, OutputStream os, boolean delete) throws IOException {
        String mail;
        Element eResource = new Element("resource", XmlServlet.NS);
        if (delete) {
            DataWriter.addElement(STR_OBJECTSTATUS, STR_DELETE, eResource);
            DataWriter.addElement(STR_OBJECTSTATUS_OLD, STR_DELETE, eResource);
        } else {
            DataWriter.addElement(STR_OBJECTSTATUS, STR_CREATE, eResource);
            DataWriter.addElement(STR_OBJECTSTATUS_OLD, STR_CREATE, eResource);
        }
        DataWriter.addElement("uid", resource.getIdentifier(), eResource);
        DataWriter.addElement("last_modified", resource.getLastModified(), eResource);
        String displayName = resource.getDisplayName();
        if (displayName != null) {
            DataWriter.addElement("displayname", displayName, eResource);
        }
        if ((mail = resource.getMail()) != null) {
            DataWriter.addElement("email1", mail, eResource);
        }
        xo.output(eResource, os);
        os.flush();
    }

    public void doError(HttpServletResponse resp) {
        this.doError(resp, 500, "Server Error");
    }

    public void doError(HttpServletResponse resp, int code, String msg) {
        try {
            LOG.debug("status: {} message: {}", (Object)code, (Object)msg);
            resp.setStatus(code);
            resp.setContentType("text/html");
        }
        catch (Exception exc) {
            LOG.error("doError", (Throwable)exc);
        }
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        return UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx).hasWebDAVXML();
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }
}

