/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.util.TimeZones;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.ratelimit.RateLimitedException;
import com.openexchange.user.UserService;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class freebusy
extends HttpServlet {
    private static final long serialVersionUID = 6336387126907903347L;
    private static final Logger LOG = LoggerFactory.getLogger(freebusy.class);
    private static final DateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat outputFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            req.getSession(true);
            super.service((HttpServletRequest)new CountingHttpServletRequest(req), resp);
        }
        catch (RateLimitedException e) {
            resp.setContentType("text/plain; charset=UTF-8");
            if (e.getRetryAfter() > 0) {
                resp.setHeader("Retry-After", String.valueOf(e.getRetryAfter()));
            }
            resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mailAddress;
        Date end;
        Date start;
        Context context = this.getContext(request);
        if (null == context) {
            response.sendError(404, "Unable to determine context.");
            return;
        }
        int period = this.getPeriod(request);
        if (-1 == period) {
            start = this.getStart(request);
            if (null == start) {
                response.sendError(400, "Unable to determine start of free busy time frame.");
                return;
            }
            end = this.getEnd(request);
            if (null == end) {
                response.sendError(400, "Unable to determine end of free busy time frame.");
                return;
            }
        } else {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(2, -period);
            start = calendar2.getTime();
            calendar2.setTimeInMillis(System.currentTimeMillis());
            calendar2.add(2, period);
            end = calendar2.getTime();
        }
        if (null == (mailAddress = this.getMailAddress(request))) {
            response.sendError(400, "Unable to determine mail address.");
            return;
        }
        Participant participant = this.findParticipant(context, mailAddress);
        if (null == participant) {
            response.sendError(404, "Unable to resolve mail address to a user or a resource.");
            return;
        }
        boolean simple = this.getSimple(request);
        response.setContentType("text/calendar");
        PrintWriter printWriter = response.getWriter();
        this.writeVCalendar(context, start, end, mailAddress, participant.getIdentifier(), participant.getType(), printWriter, simple);
    }

    private String getMailAddress(HttpServletRequest request) {
        String userName = request.getParameter("username");
        String serverName = request.getParameter("server");
        if (null == userName || null == serverName) {
            return null;
        }
        return userName + '@' + serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getStart(HttpServletRequest request) {
        Date start;
        if (null == request.getParameter("start")) {
            return null;
        }
        try {
            DateFormat dateFormat = inputFormat;
            synchronized (dateFormat) {
                start = inputFormat.parse(request.getParameter("start"));
            }
        }
        catch (ParseException e) {
            LOG.debug("Unable to parse parameter start.", (Throwable)e);
            return null;
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getEnd(HttpServletRequest request) {
        Date end;
        if (null == request.getParameter("end")) {
            return null;
        }
        try {
            DateFormat dateFormat = inputFormat;
            synchronized (dateFormat) {
                end = inputFormat.parse(request.getParameter("end"));
            }
        }
        catch (ParseException e) {
            LOG.debug("Unable to parse parameter end.", (Throwable)e);
            return null;
        }
        return end;
    }

    private Context getContext(HttpServletRequest request) {
        Context context;
        int contextId;
        if (request.getParameter("contextid") == null) {
            return null;
        }
        try {
            contextId = Integer.parseInt(request.getParameter("contextid"));
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse context identifier.", (Throwable)e);
            return null;
        }
        try {
            ContextService service = ServerServiceRegistry.getInstance().getService(ContextService.class, true);
            context = service.getContext(contextId);
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
        catch (OXException e) {
            LOG.error("Can not load context.", (Throwable)e);
            return null;
        }
        return context;
    }

    private int getPeriod(HttpServletRequest request) {
        int period;
        if (null == request.getParameter("period")) {
            return -1;
        }
        try {
            period = Integer.parseInt(request.getParameter("period"));
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to parse period parameter.", (Throwable)e);
            return -1;
        }
        return period;
    }

    private boolean getSimple(HttpServletRequest request) {
        String simple = request.getParameter("simple");
        if (null != simple && 0 < simple.length()) {
            return Boolean.parseBoolean(simple);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVCalendar(Context context, Date start, Date end, String mailAddress, int principalId, int type, PrintWriter printWriter, boolean simple) {
        printWriter.println("BEGIN:VCALENDAR");
        printWriter.println("PRODID:-//www.open-xchange.org//");
        printWriter.println("VERSION:2.0");
        printWriter.println("METHOD:PUBLISH");
        printWriter.println("BEGIN:VFREEBUSY");
        printWriter.println("ORGANIZER:" + mailAddress);
        DateFormat dateFormat = outputFormat;
        synchronized (dateFormat) {
            printWriter.println("DTSTART:" + outputFormat.format(start));
            printWriter.println("DTEND:" + outputFormat.format(end));
        }
        try {
            SessionObject session = SessionObjectWrapper.createSessionObject(1 == type ? principalId : context.getMailadmin(), context, "freebusysessionobject");
            AppointmentSQLInterface appointmentInterface = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class, true).createAppointmentSql((Session)session);
            SearchIterator<Appointment> it = appointmentInterface.getFreeBusyInformation(principalId, type, start, end);
            try {
                while (it.hasNext()) {
                    this.writeFreeBusy((Appointment)it.next(), printWriter, outputFormat, simple);
                    printWriter.flush();
                }
            }
            finally {
                it.close();
            }
        }
        catch (ServiceException e) {
            LOG.error("Calendar service not found.", (Throwable)e);
        }
        catch (OXException e) {
            LOG.error("Problem getting free busy information for '{}'.", (Object)mailAddress, (Object)e);
        }
        catch (RuntimeException e) {
            LOG.error("Problem getting free busy information for '{}'.", (Object)mailAddress, (Object)e);
        }
        printWriter.println("END:VFREEBUSY");
        printWriter.println("END:VCALENDAR");
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFreeBusy(Appointment appointment, PrintWriter pw, DateFormat format, boolean simple) {
        if (simple) {
            if (4 == appointment.getShownAs()) {
                return;
            }
            pw.print("FREEBUSY:");
        } else {
            pw.print("FREEBUSY;FBTYPE=");
            switch (appointment.getShownAs()) {
                case 4: {
                    pw.print("FREE:");
                    break;
                }
                case 2: {
                    pw.print("BUSY-TENTATIVE:");
                    break;
                }
                case 3: {
                    pw.print("BUSY-UNAVAILABLE:");
                    break;
                }
                default: {
                    pw.print("BUSY:");
                }
            }
        }
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            pw.print(format.format(appointment.getStartDate()));
            pw.print('/');
            pw.println(format.format(appointment.getEndDate()));
        }
    }

    private Participant findParticipant(Context ctx, String mailAddress) {
        ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
        User user = null;
        try {
            UserService service = serviceRegistry.getService(UserService.class, true);
            user = service.searchUser(mailAddress, ctx);
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
        }
        catch (OXException e) {
            LOG.debug("User '{}' not found.", (Object)mailAddress);
        }
        Resource resource = null;
        try {
            ResourceService service = serviceRegistry.getService(ResourceService.class, true);
            Resource[] resources = service.searchResourcesByMail(mailAddress, ctx);
            if (1 == resources.length) {
                resource = resources[0];
            }
        }
        catch (ServiceException e) {
            LOG.error("", (Throwable)e);
        }
        catch (OXException e) {
            LOG.error("Resource '{}' not found.", (Object)mailAddress);
        }
        Comparable<Participant> retval = null;
        if (!(null == resource || user != null && user.getMail().equals(mailAddress))) {
            retval = new ResourceParticipant(resource.getIdentifier());
        } else if (null != user) {
            retval = new UserParticipant(user.getId());
        }
        return retval;
    }

    static {
        outputFormat.setTimeZone(TimeZones.UTC);
    }
}

